//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Projection/ProjectionsPlot.h
//! @brief     Defines class ProjectionsPlot
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PROJECTION_PROJECTIONSPLOT_H
#define BORNAGAIN_GUI_VIEW_PROJECTION_PROJECTIONSPLOT_H

#include "GUI/Support/Data/ID.h"
#include "GUI/View/Item/DataItemBundleWidget.h"
#include <QMap>

class Datafield;
class IntensityDataItem;
class MaskItem;
class MaskItemObject;
class ProjectionContainerItem;
class QCPGraph;
class QCustomPlot;

//! A customplot based widget to display projections of IntensityDataItem on X,Y axes.

class ProjectionsPlot : public DataItemBundleWidget {
    Q_OBJECT

public:
    ProjectionsPlot(GUI::ID::ProjectionType projectionType, QWidget* parent = nullptr);

    void setIntensityItem(IntensityDataItem* intensityDataItem) override;

    void connectItems();
    void disconnectItems();

public slots:
    void onMarginsChanged(double left, double right);

private:
    IntensityDataItem* intensityItem();
    QVector<MaskItem*> projectionItems();
    bool isCorrectProjectionType(MaskItem* item);
    ProjectionContainerItem* projectionContainerItem();
    QCPGraph* graphForItem(MaskItemObject* item);

    void updateProjectionsData();
    void updateProjections();
    void onProjectionPropertyChanged(MaskItemObject* item);
    void updateAxesRange();
    void updateAxesTitle();
    void clearProjection(MaskItemObject* item);
    void clearAll();

    void setGraphFromItem(QCPGraph* graph, MaskItem* item);

    void setInterpolate(bool isInterpolated);
    void setLogz(bool isLogz);

    void replot();

    bool isHorizontalType();

    GUI::ID::ProjectionType m_projectionType = GUI::ID::ProjectionType::Invalid;
    QCustomPlot* m_customPlot;
    QMap<MaskItemObject*, QCPGraph*> m_item_to_graph;
};

#endif // BORNAGAIN_GUI_VIEW_PROJECTION_PROJECTIONSPLOT_H
