;          MINMAXD.ASM                                          Agner Fog 2004

;  2004 GNU General Public License www.gnu.org/copyleft/gpl.html

.686
.xmm
.model flat

extrn instrset:dword, InstructionSet:near

; macro definitions

PublicAlias MACRO MangledName ; macro for giving a function alias public names
        MangledName label near
        public MangledName
ENDM

; MASM v. 6.15 cannot handle the MOVSD XMM instruction (move scalar double)
; because it is confused with the string instruction of the same name.
; This macro is a workaround, giving the MOVSD XMM instruction
MOVSD@  MACRO   X, Y
        DB      0F2H
        MOVUPS  X, Y
ENDM        


.code   ; code segment

; ********** MinD function **********
; C++ prototype:
; extern "C" double MinD (double a, double b);

; Returns the lowest of the double precision floating point numbers a and b.

MinD PROC NEAR
PUBLIC MinD
PublicAlias _MinD                   ; Underscore needed when called from Windows
        cmp     [instrset], 4       ; can we use XMM instructions?
        jl      NO_SSE2
        ; use SSE2 (XMM) instruction set:
        MOVSD@  xmm0, [esp+4]       ; get a
        minsd   xmm0, [esp+12]      ; min(a,b)
        MOVSD@  [esp+4], xmm0       ; store in a
        fld     qword ptr [esp+4]   ; load into st(0)
        ret                         ; return value in st(0)

NO_SSE2:cmp     [instrset], 2       ; can we use FCMOV and FCOMI instructions?
        jl      NO_CMOV
        ;       use FCMOV and FCOMI instructions
        fld     qword ptr [esp+4]   ; a
        fld     qword ptr [esp+12]  ; b
        fcomi   st(0),st(1)         ; compare
        fcmovnb st(0),st(1)         ; get the lowest
        fstp    st(1)               ; discard st(1)        
        ret

NO_CMOV:cmp     [instrset], 0
        jl      DETECT_INSTRUCTIONSET
        ; default instruction set:
        fld     qword ptr [esp+4]   ; a
        fcom    qword ptr [esp+12]  ; b
        fnstsw  ax
        and     ah, 1
        jnz     SMALLER             ; st(0) < b
        ; a >= b
        fstp    st(0)               ; discard a
        fld     qword ptr [esp+12]  ; load b
SMALLER:ret

DETECT_INSTRUCTIONSET:              ; first time call. detect instruction set
        call    InstructionSet
        jmp     MinD        
MinD ENDP

; ********** MaxD function **********
; C++ prototype:
; extern "C" double MaxD (double a, double b);

; Returns the highest of the double precision floating point numbers a and b.

MaxD PROC NEAR
PUBLIC MaxD
PublicAlias _MaxD                   ; Underscore needed when called from Windows
        cmp     [instrset], 4       ; can we use XMM instructions?
        jl      NOSSE2
        ; use SSE2 (XMM) instruction set:
        MOVSD@  xmm0, [esp+4]       ; get a
        maxsd   xmm0, [esp+12]      ; max(a,b)
        MOVSD@  [esp+4], xmm0       ; store in a
        fld     qword ptr [esp+4]   ; load into st(0)
        ret                         ; return value in st(0)

NOSSE2: cmp     [instrset], 2       ; can we use FCMOV and FCOMI instructions?
        jl      NOCMOV
        ;       use FCMOV and FCOMI instructions
        fld     qword ptr [esp+4]   ; a
        fld     qword ptr [esp+12]  ; b
        fcomi   st(0),st(1)         ; compare
        fcmovb  st(0),st(1)         ; get the highest
        fstp    st(1)               ; discard st(1)        
        ret

NOCMOV: cmp     [instrset], 0
        jl      DETECTINSTRUCTIONSET
        ; default instruction set:
        fld     qword ptr [esp+4]   ; a
        fcom    qword ptr [esp+12]  ; b
        fnstsw  ax
        and     ah, 1
        jz      BIGGER              ; st(0) >= b
        ; a < b
        fstp    st(0)               ; discard a
        fld     qword ptr [esp+12]  ; load b
BIGGER: ret

DETECTINSTRUCTIONSET:               ; first time call. detect instruction set
        call    InstructionSet
        jmp     MaxD        
MaxD ENDP

END
