#ifndef ASFREADSTREAM_H
#define ASFREADSTREAM_H

#include "ReadHandlers.h"
#include "AsfInputStream.h"
#include "infotypes.h"

AVM_BEGIN_NAMESPACE;

class AsfReadHandler;

class AsfReadStream : public IMediaReadStream
{
friend class AsfReadHandler;
public:
    AsfReadStream(AsfReadHandler* parent);
    virtual ~AsfReadStream();
    virtual void ClearCache();
    virtual double CacheSize() const;
    virtual bool IsKeyFrame(framepos_t frame = ERR) const;
    virtual size_t GetHeader(void* header = 0, size_t size = 0) const;
    virtual size_t GetFormat(void *format = 0, size_t size = 0) const;
    virtual double GetFrameTime() const;
    virtual framepos_t GetLength() const;
    virtual double GetLengthTime() const;
    virtual framepos_t GetPrevKeyFrame(framepos_t frame = ERR) const;
    virtual framepos_t GetNextKeyFrame(framepos_t frame = ERR) const;
    virtual framepos_t GetNearestKeyFrame(framepos_t frame = ERR) const;
    virtual size_t GetSampleSize() const;
    virtual StreamInfo* GetStreamInfo() const;
    virtual double GetTime(framepos_t frame = ERR) const;
    virtual IStream::StreamType GetType() const;
    virtual StreamPacket* ReadPacket();
    virtual int Seek(framepos_t framepos);
    virtual int SeekTime(double timepos);
    virtual int SkipFrame();
    virtual int SkipTo(double timepos);

protected:
    void ReadPacketInternal() const;
    AsfPacket* GetNextAsfPacket() const
    {
	while (!m_pIterator->isEof())
	{
	    if (m_pAsfPacket)
		m_pAsfPacket->release();
	    if (!(m_pAsfPacket = m_pIterator->getPacket())
		|| !m_pAsfPacket->fragments.size())
		continue;

	    m_uiFragId = 0;

	    //printf("Packet %p  %d   for %p\n", m_pAsfPacket, m_pAsfPacket->refcount, this);
	    return m_pAsfPacket;
	}
	return 0;
    }

    ASFStreamHeader m_Header;
    const AsfStreamSeekInfo* m_pSeekInfo;
    const ASFSpreadAudio* m_pScrambleDef;
    mutable AsfReadHandler* m_pHandler;
    mutable StreamInfo m_StreamInfo;
    mutable AsfIterator* m_pIterator;
    mutable StreamPacket* m_pStrPacket;
    mutable AsfPacket* m_pAsfPacket;
    mutable unsigned m_uiFragId;
    mutable unsigned m_uiLastPos;
    mutable double m_dLastTime;
    int m_iId;
    int m_iMaxBitrate;
    bool m_bIsAudio;
    bool m_bIsScrambled;
};

AVM_END_NAMESPACE;

#endif // ASFREADSTREAM_H
