/*
** In this include-file specific structs are defined which are filled
** by sscanf-ing the ascii-values produced by reading several /proc-files.
*/

typedef long long       count_t;

/*
** Obtained from /usr/src/linux/include/net/snmp.h
*/
struct ip_mib {
 	count_t	IpForwarding;
 	count_t	IpDefaultTTL;
 	count_t	IpInReceives;
 	count_t	IpInHdrErrors;
 	count_t	IpInAddrErrors;
 	count_t	IpForwDatagrams;
 	count_t	IpInUnknownProtos;
 	count_t	IpInDiscards;
 	count_t	IpInDelivers;
 	count_t	IpOutRequests;
 	count_t	IpOutDiscards;
 	count_t	IpOutNoRoutes;
 	count_t	IpReasmTimeout;
 	count_t	IpReasmReqds;
 	count_t	IpReasmOKs;
 	count_t	IpReasmFails;
 	count_t	IpFragOKs;
 	count_t	IpFragFails;
 	count_t	IpFragCreates;
};
 
struct ipv6_mib {
	count_t	Ip6InReceives;
 	count_t	Ip6InHdrErrors;
 	count_t	Ip6InTooBigErrors;
 	count_t	Ip6InNoRoutes;
 	count_t	Ip6InAddrErrors;
 	count_t	Ip6InUnknownProtos;
 	count_t	Ip6InTruncatedPkts;
 	count_t	Ip6InDiscards;
 	count_t	Ip6InDelivers;
 	count_t	Ip6OutForwDatagrams;
 	count_t	Ip6OutRequests;
 	count_t	Ip6OutDiscards;
 	count_t	Ip6OutNoRoutes;
 	count_t	Ip6ReasmTimeout;
 	count_t	Ip6ReasmReqds;
 	count_t	Ip6ReasmOKs;
 	count_t	Ip6ReasmFails;
 	count_t	Ip6FragOKs;
 	count_t	Ip6FragFails;
 	count_t	Ip6FragCreates;
 	count_t	Ip6InMcastPkts;
 	count_t	Ip6OutMcastPkts;
};
 
struct icmp_mib {
 	count_t	IcmpInMsgs;
 	count_t	IcmpInErrors;
  	count_t	IcmpInDestUnreachs;
 	count_t	IcmpInTimeExcds;
 	count_t	IcmpInParmProbs;
 	count_t	IcmpInSrcQuenchs;
 	count_t	IcmpInRedirects;
 	count_t	IcmpInEchos;
 	count_t	IcmpInEchoReps;
 	count_t	IcmpInTimestamps;
 	count_t	IcmpInTimestampReps;
 	count_t	IcmpInAddrMasks;
 	count_t	IcmpInAddrMaskReps;
 	count_t	IcmpOutMsgs;
 	count_t	IcmpOutErrors;
 	count_t	IcmpOutDestUnreachs;
 	count_t	IcmpOutTimeExcds;
 	count_t	IcmpOutParmProbs;
 	count_t	IcmpOutSrcQuenchs;
 	count_t	IcmpOutRedirects;
 	count_t	IcmpOutEchos;
 	count_t	IcmpOutEchoReps;
 	count_t	IcmpOutTimestamps;
 	count_t	IcmpOutTimestampReps;
 	count_t	IcmpOutAddrMasks;
 	count_t	IcmpOutAddrMaskReps;
};

struct icmpv6_mib {
	count_t	Icmp6InMsgs;
	count_t	Icmp6InErrors;

	count_t	Icmp6InDestUnreachs;
	count_t	Icmp6InPktTooBigs;
	count_t	Icmp6InTimeExcds;
	count_t	Icmp6InParmProblems;

	count_t	Icmp6InEchos;
	count_t	Icmp6InEchoReplies;
	count_t	Icmp6InGroupMembQueries;
	count_t	Icmp6InGroupMembResponses;
	count_t	Icmp6InGroupMembReductions;
	count_t	Icmp6InRouterSolicits;
	count_t	Icmp6InRouterAdvertisements;
	count_t	Icmp6InNeighborSolicits;
	count_t	Icmp6InNeighborAdvertisements;
	count_t	Icmp6InRedirects;

	count_t	Icmp6OutMsgs;

	count_t	Icmp6OutDestUnreachs;
	count_t	Icmp6OutPktTooBigs;
	count_t	Icmp6OutTimeExcds;
	count_t	Icmp6OutParmProblems;

	count_t	Icmp6OutEchoReplies;
	count_t	Icmp6OutRouterSolicits;
	count_t	Icmp6OutNeighborSolicits;
	count_t	Icmp6OutNeighborAdvertisements;
	count_t	Icmp6OutRedirects;
	count_t	Icmp6OutGroupMembResponses;
	count_t	Icmp6OutGroupMembReductions;
};
 
struct tcp_mib {
 	count_t	TcpRtoAlgorithm;
 	count_t	TcpRtoMin;
 	count_t	TcpRtoMax;
 	count_t	TcpMaxConn;
 	count_t	TcpActiveOpens;
 	count_t	TcpPassiveOpens;
 	count_t	TcpAttemptFails;
 	count_t	TcpEstabResets;
 	count_t	TcpCurrEstab;
 	count_t	TcpInSegs;
 	count_t	TcpOutSegs;
 	count_t	TcpRetransSegs;
 	count_t	TcpInErrs;
 	count_t	TcpOutRsts;
};
 
struct udp_mib {
 	count_t	UdpInDatagrams;
 	count_t	UdpNoPorts;
 	count_t	UdpInErrors;
 	count_t	UdpOutDatagrams;
};

struct linux_mib {
	count_t	SyncookiesSent;
	count_t	SyncookiesRecv;
	count_t	SyncookiesFailed;
	count_t	EmbryonicRsts;
	count_t	PruneCalled; 
	count_t	RcvPruned;
	count_t	OfoPruned;
	count_t	OutOfWindowIcmps; 
	count_t	LockDroppedIcmps; 
};

/*
** Kernel-version info
*/
struct osrel {
        int   rel;
        int   vers;
        int   sub;
};


/*
** integer values taken from the output of the file
**            /proc/net/snmp and /proc/net/snmp6
*/
struct netstat {
	struct ip_mib		ip;
	struct icmp_mib		icmp;
	struct tcp_mib		tcp;
	struct udp_mib		udp;

	struct ipv6_mib		ip6;
	struct icmpv6_mib	icmp6;
	struct udp_mib		udp6;
};


/*
** proprietary struct for NFS-counters
*/
struct nfsstat {
	count_t	cl_netcnt;
	count_t	cl_netudpcnt;
	count_t	cl_nettcpcnt;
	count_t	cl_nettcpconn;
	count_t	cl_rpccnt;
	count_t	cl_rpcretrans;
	count_t	cl_rpcauthrefresh;
	count_t	cl_proc2[20];
	count_t	cl_proc3[20];

	count_t	sv_netcnt;
	count_t	sv_netudpcnt;
	count_t	sv_nettcpcnt;
	count_t	sv_nettcpconn;
	count_t	sv_rpccnt;
	count_t	sv_rpcbadtot;
	count_t	sv_rpcbadfmt;
	count_t	sv_rpcbadauth;
	count_t	sv_rpcbadclnt;
	count_t	sv_proc2[20];
	count_t	sv_proc3[20];
	count_t	sv_rchits;
	count_t	sv_rcmisses;
	count_t	sv_rcnocache;
	count_t	sv_fhstale;
	count_t	sv_fhlookup;
	count_t	sv_fhanon;
	count_t	sv_fhnocachedir;
	count_t	sv_fhnocachenondir;
	count_t	sv_ioread;
	count_t	sv_iowrite;
	count_t	sv_thcount;
	count_t	sv_thlastcnt;
	count_t	sv_rasize;
};

/*
** proprietary struct for ftp- and http-counters
*/
#define	MAXLOGNAME	32

struct ftpstat {
	double		ocumxfer;
	double		ocumseconds;
	double		ocumkbytes;
	double		icumxfer;
	double		icumseconds;
	double		icumkbytes;
	char 		logname[MAXLOGNAME];
};

struct httpstat {
	double		cumhead;
	double		cumgets;
	double		cumputs;
	double		cumpost;
	double		cumdels;
	char 		logname[MAXLOGNAME];
};

/*
** integer values taken from the output of the /proc/net/dev file
*/
#define	MAXIFNAME	16

struct ifstat {
	char 		name[MAXIFNAME];
	count_t	rbyte;
	count_t	rpack;
	count_t	rerrs;
	count_t	rdrop;
	count_t	rfifo;
	count_t	rframe;
	count_t	rcompr;
	count_t	rmultic;
	count_t	sbyte;
	count_t	spack;
	count_t	serrs;
	count_t	sdrop;
	count_t	sfifo;
	count_t	scollis;
	count_t	scarrier;
	count_t	scompr;
};


/*
** kernel-table occupation
*/
struct tabstat {
	count_t	totforks;

	count_t	curlocks;
	count_t	maxlocks;

	count_t	maxdquot;
	count_t	curdquot;

	count_t	maxfiles;
	count_t	curfiles;

	count_t	maxinode;
	count_t	curinode;

	count_t	maxsuper;
	count_t	cursuper;
};

/*
** integer values taken from the output of the /proc/meminfo file
*/
struct memstat {
	count_t	memtot;
	count_t	memfree;
	count_t	membuf;
	count_t	memcache;
	count_t	memslab;
	count_t	swptot;
	count_t	swpfree;
};


/*
** Per-partition statistics
*/
#define MAXDKNAME	16

struct dkstat {
	unsigned short	major;
	unsigned short	minor;
	char 		name[MAXDKNAME];

	count_t	totsize;
	count_t	readblocks;
	count_t	readmerges;
	count_t	readsectors;
	count_t	read_msecs;

	count_t	writblocks;
	count_t	writmerges;
	count_t	writsectors;
	count_t	writ_msecs;

	count_t	reqpending;
	count_t	rdwr_msecs;
	count_t	avq;
};


/*
** Serial interface statistics
*/
struct serialstat {
	count_t	port;
	count_t	tx;	/* transmits 		*/
	count_t	rx;	/* receives 		*/
	count_t	fe;	/* frame errors		*/
	count_t	pe;	/* parity errors	*/
	count_t	br;	/* breaks 		 	*/
	count_t	oe;	/* overrun errors	*/
};


/*
** Private structure to store all general system-related counters
** in a uniform version-independent way
*/
#define MAXCPU	32
#define	MAXIRQ	64
#define MAXDISK	64

struct genstat {
	/* CPU-related stuff */
	count_t	cpu_user;
	count_t	cpu_nice;
	count_t	cpu_system;
	count_t	cpu_idle;
	count_t	cpu_wait;
	count_t	cpu_irq;
	count_t	cpu_sirq;

	count_t	per_cpu_user[MAXCPU];
	count_t	per_cpu_nice[MAXCPU];
	count_t	per_cpu_system[MAXCPU];
	count_t	per_cpu_idle[MAXCPU];
	count_t	per_cpu_wait[MAXCPU];
	count_t	per_cpu_irq[MAXCPU];
	count_t	per_cpu_sirq[MAXCPU];

	count_t	irqs[MAXIRQ];
	count_t	per_irqs[MAXCPU][MAXIRQ];
	count_t	context_swtch;

	float	loadavg1;
	float	loadavg5;
	float	loadavg15;
	count_t	nrrun;
	count_t	nrproc;

	/* disk-related stuff */
	count_t	dk_drive_maj[MAXDISK+1];
	count_t	dk_drive_min[MAXDISK+1];
	count_t	dk_drive_tot[MAXDISK+1];
	count_t	dk_drive_rio[MAXDISK+1];
	count_t	dk_drive_wio[MAXDISK+1];
	count_t	dk_drive_rblk[MAXDISK+1];
	count_t	dk_drive_wblk[MAXDISK+1];

	/* memory-related stuff */
	count_t	pgpgin;
	count_t	pgpgout;
	count_t	pswpin;
	count_t	pswpout;
};

/*
** Structure to store socket-usage figures
*/
struct sockstat {
	count_t   tcpnow;
	count_t   tcpmax;
	count_t   udpnow;
	count_t   udpmax;

	count_t   tcp6now;
	count_t   tcp6max;
	count_t   udp6now;
	count_t   udp6max;
};
