/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.verifier.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.generic.BranchHandle;
import org.aspectj.apache.bcel.generic.CodeExceptionGen;
import org.aspectj.apache.bcel.generic.FieldInstruction;
import org.aspectj.apache.bcel.generic.IINC;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionBranch;
import org.aspectj.apache.bcel.generic.InstructionByte;
import org.aspectj.apache.bcel.generic.InstructionCP;
import org.aspectj.apache.bcel.generic.InstructionConstants;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionSelect;
import org.aspectj.apache.bcel.generic.InvokeInstruction;
import org.aspectj.apache.bcel.generic.MULTIANEWARRAY;
import org.aspectj.apache.bcel.generic.MethodGen;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.RET;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.verifier.EmptyInstVisitor;
import org.aspectj.apache.bcel.verifier.InstructionWalker;
import org.aspectj.apache.bcel.verifier.util.BCELifier;

class BCELFactory
extends EmptyInstVisitor {
    private final MethodGen _mg;
    private final PrintWriter _out;
    private final ConstantPool _cp;
    private final HashMap<Instruction, InstructionHandle> branch_map = new HashMap();
    private final ArrayList<InstructionBranch> branches = new ArrayList();

    BCELFactory(MethodGen mg, PrintWriter out) {
        this._mg = mg;
        this._cp = mg.getConstantPool();
        this._out = out;
    }

    public void start() {
        if (!this._mg.isAbstract() && !this._mg.isNative()) {
            InstructionHandle ih = this._mg.getInstructionList().getStart();
            while (ih != null) {
                Instruction i = ih.getInstruction();
                if (i instanceof InstructionBranch) {
                    this.branch_map.put(i, ih);
                }
                if (ih.hasTargeters()) {
                    if (i instanceof InstructionBranch) {
                        this._out.println("    InstructionHandle ih_" + ih.getPosition() + ";");
                    } else {
                        this._out.print("    InstructionHandle ih_" + ih.getPosition() + " = ");
                    }
                } else {
                    this._out.print("    ");
                }
                if (!this.visitInstruction(i)) {
                    InstructionWalker.accept(i, this);
                }
                ih = ih.getNext();
            }
            this.updateBranchTargets();
            this.updateExceptionHandlers();
        }
    }

    private boolean visitInstruction(Instruction i) {
        short opcode = i.getOpcode();
        if (InstructionConstants.INSTRUCTIONS[opcode] != null && !i.isConstantInstruction() && !i.isReturnInstruction()) {
            this._out.println("il.append(InstructionConstants." + i.getName().toUpperCase() + ");");
            return true;
        }
        return false;
    }

    public void visitLocalVariableInstruction(Instruction i) {
        short opcode = i.getOpcode();
        Type type = i.getType(this._cp);
        if (opcode == 132) {
            this._out.println("il.append(new IINC(" + i.getIndex() + ", " + ((IINC)i).getIncrement() + "));");
        } else {
            String kind = opcode < 54 ? "Load" : "Store";
            this._out.println("il.append(_factory.create" + kind + "(" + BCELifier.printType(type) + ", " + i.getIndex() + "));");
        }
    }

    public void visitArrayInstruction(Instruction i) {
        short opcode = i.getOpcode();
        Type type = i.getType(this._cp);
        String kind = opcode < 79 ? "Load" : "Store";
        this._out.println("il.append(_factory.createArray" + kind + "(" + BCELifier.printType(type) + "));");
    }

    public void visitFieldInstruction(FieldInstruction i) {
        short opcode = i.getOpcode();
        String class_name = i.getClassName(this._cp);
        String field_name = i.getFieldName(this._cp);
        Type type = i.getFieldType(this._cp);
        this._out.println("il.append(_factory.createFieldAccess(\"" + class_name + "\", \"" + field_name + "\", " + BCELifier.printType(type) + ", " + "Constants." + Constants.OPCODE_NAMES[opcode].toUpperCase() + "));");
    }

    public void visitInvokeInstruction(InvokeInstruction i) {
        short opcode = i.getOpcode();
        String class_name = i.getClassName(this._cp);
        String method_name = i.getMethodName(this._cp);
        Type type = i.getReturnType(this._cp);
        Type[] arg_types = i.getArgumentTypes(this._cp);
        this._out.println("il.append(_factory.createInvoke(\"" + class_name + "\", \"" + method_name + "\", " + BCELifier.printType(type) + ", " + BCELifier.printArgumentTypes(arg_types) + ", " + "Constants." + Constants.OPCODE_NAMES[opcode].toUpperCase() + "));");
    }

    public void visitAllocationInstruction(Instruction i) {
        Type type = i.isConstantPoolInstruction() ? ((InstructionCP)i).getType(this._cp) : ((InstructionByte)i).getType();
        short opcode = i.getOpcode();
        short dim = 1;
        switch (opcode) {
            case 187: {
                this._out.println("il.append(_factory.createNew(\"" + ((ObjectType)type).getClassName() + "\"));");
                break;
            }
            case 197: {
                dim = ((MULTIANEWARRAY)i).getDimensions();
            }
            case 188: 
            case 189: {
                this._out.println("il.append(_factory.createNewArray(" + BCELifier.printType(type) + ", (short) " + dim + "));");
                break;
            }
            default: {
                throw new RuntimeException("Oops: " + opcode);
            }
        }
    }

    private void createConstant(Object value) {
        String embed = value.toString();
        if (value instanceof String) {
            embed = String.valueOf('\"') + Utility.convertString((String)value.toString()) + '\"';
        } else if (value instanceof Character) {
            embed = "(char)0x" + Integer.toHexString(((Character)value).charValue());
        }
        this._out.println("il.append(new PUSH(_cp, " + embed + "));");
    }

    public void visitLDC(Instruction i) {
        this.createConstant(i.getValue(this._cp));
    }

    public void visitLDC2_W(Instruction i) {
        this.createConstant(i.getValue(this._cp));
    }

    public void visitConstantPushInstruction(Instruction i) {
        this.createConstant(i.getValue());
    }

    public void visitINSTANCEOF(Instruction i) {
        Type type = i.getType(this._cp);
        this._out.println("il.append(new INSTANCEOF(_cp.addClass(" + BCELifier.printType(type) + ")));");
    }

    public void visitCHECKCAST(Instruction i) {
        Type type = i.getType(this._cp);
        this._out.println("il.append(_factory.createCheckCast(" + BCELifier.printType(type) + "));");
    }

    public void visitReturnInstruction(Instruction i) {
        Type type = i.getType(this._cp);
        this._out.println("il.append(_factory.createReturn(" + BCELifier.printType(type) + "));");
    }

    public void visitBranchInstruction(InstructionBranch bi) {
        BranchHandle bh = (BranchHandle)this.branch_map.get(bi);
        int pos = bh.getPosition();
        String name = String.valueOf(bi.getName()) + "_" + pos;
        if (bi instanceof InstructionSelect) {
            InstructionSelect s = (InstructionSelect)bi;
            this.branches.add(bi);
            StringBuffer args = new StringBuffer("new int[] { ");
            int[] matchs = s.getMatchs();
            int i = 0;
            while (i < matchs.length) {
                args.append(matchs[i]);
                if (i < matchs.length - 1) {
                    args.append(", ");
                }
                ++i;
            }
            args.append(" }");
            this._out.print("    Select " + name + " = new " + bi.getName().toUpperCase() + "(" + args + ", new InstructionHandle[] { ");
            i = 0;
            while (i < matchs.length) {
                this._out.print("null");
                if (i < matchs.length - 1) {
                    this._out.print(", ");
                }
                ++i;
            }
            this._out.println(");");
        } else {
            String target;
            int t_pos = bh.getTarget().getPosition();
            if (pos > t_pos) {
                target = "ih_" + t_pos;
            } else {
                this.branches.add(bi);
                target = "null";
            }
            this._out.println("    BranchInstruction " + name + " = _factory.createBranchInstruction(" + "Constants." + bi.getName().toUpperCase() + ", " + target + ");");
        }
        if (bh.hasTargeters()) {
            this._out.println("    ih_" + pos + " = il.append(" + name + ");");
        } else {
            this._out.println("    il.append(" + name + ");");
        }
    }

    public void visitRET(RET i) {
        this._out.println("il.append(new RET(" + i.getIndex() + ")));");
    }

    private void updateBranchTargets() {
        for (InstructionBranch bi : this.branches) {
            BranchHandle bh = (BranchHandle)this.branch_map.get(bi);
            int pos = bh.getPosition();
            String name = String.valueOf(bi.getName()) + "_" + pos;
            int t_pos = bh.getTarget().getPosition();
            this._out.println("    " + name + ".setTarget(ih_" + t_pos + ");");
            if (!(bi instanceof InstructionSelect)) continue;
            InstructionHandle[] ihs = ((InstructionSelect)bi).getTargets();
            int j = 0;
            while (j < ihs.length) {
                t_pos = ihs[j].getPosition();
                this._out.println("    " + name + ".setTarget(" + j + ", ih_" + t_pos + ");");
                ++j;
            }
        }
    }

    private void updateExceptionHandlers() {
        CodeExceptionGen[] handlers = this._mg.getExceptionHandlers();
        int i = 0;
        while (i < handlers.length) {
            CodeExceptionGen h = handlers[i];
            String type = h.getCatchType() == null ? "null" : BCELifier.printType((Type)h.getCatchType());
            this._out.println("    method.addExceptionHandler(ih_" + h.getStartPC().getPosition() + ", " + "ih_" + h.getEndPC().getPosition() + ", " + "ih_" + h.getHandlerPC().getPosition() + ", " + type + ");");
            ++i;
        }
    }
}

