// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __unit_iterator__
#define __unit_iterator__

// Iterator for token units.

#include "Puma/Unit.h"
#include "Puma/ListElement.h"

namespace Puma {


class Token;

class UnitIterator {
  Unit  *_unit;           // Unit to iterate.
  Token *_current;        // The current token.
 
public:
  UnitIterator ();        // Nothing to iterate!

  // Unit to iterate is the unit the given token belongs to.
  UnitIterator (ListElement &);        
  UnitIterator (Unit &);
        
  // Same as UnitIterator(ListElement&) etc.
  UnitIterator &operator =(ListElement &); 
  UnitIterator &operator =(Unit &);
        
  UnitIterator &operator ++();      // Next token in unit.
  UnitIterator &operator --();      // Previous token in unit.

  Token *operator *() const;        // Get the current token itself.
  Token *operator ->() const;       // Call a member on the current token.
};


} // namespace Puma

#endif /* __unit_iterator__ */
