#!/usr/bin/perl
# Read include file, and generate function calls

$file = @ARGV[0];

if ( ! defined(open(FILE, $file)) ) {
	warn "Couldn't open $file: $!\n";
	exit;
}

print "/* Generated by call-gen.pl from $file */\n\n";

$linecount=0;
while ($ligne = <FILE>) {
	if ($ligne =~ /^GLAPI/ ) {
		while (! ($ligne =~ /\);/)) {
			chomp($ligne);
			$ligne .= " " . <FILE>;
		}
		$ligne =~ s/\t//g;
		$ligne =~ s/\n//g;
		$ligne =~ s/ +/ /g;

		# Add missing parameters (for glext.h)
		$lettre = 'a';
		while ($ligne =~ /[,\( ] *GL\w+\** *\**,/ ) {
			$ligne =~ s/([,\( ] *GL\w+\** *\**),/$1 $lettre,/;
			$lettre++;
		}
		while ($ligne =~ /[,\( ] *GL\w+\** *\**\)/ ) {
			$ligne =~ s/([,\( ] *GL\w+\** *\**)\)/$1 $lettre\)/;
			$lettre++;
		}
		while ($ligne =~ /[,\( ] *GL\w+\** *const *\*,/ ) {
			$ligne =~ s/([,\( ] *GL\w+\** *const *\*),/$1 $lettre,/;
			$lettre++;
		}

#		print "/* $ligne */\n";

		if ($ligne =~ /^GLAPI *(\w+).* (GL)*APIENTRY *(\w+) *\(.*/) {
			$return_type = $1 ;
			$function_name = $3 ;
		} else {
			$return_type = "" ;
			$function_name = "" ;
		}

		$prototype = $ligne;
		# Add object prototype
		$prototype =~ s/(GL)*APIENTRY */OSMesaDriver::nf/ ;
		$prototype =~ s/GLAPI *//;
		$prototype =~ s/;$//;
		# Remove start of line
		$ligne =~ s/^GLAPI.*(GL)*APIENTRY// ;
		$ligne =~ s/^ *// ;

		# Remove parameter types
		if ( $ligne =~ /\( *(void) *\)/ ) {
			# Remove void list of parameters
			$ligne =~ s/$1//;
		} else {
			# Remove parameters type
			while ( $ligne =~ /[,\(] *((const)* *(\w)+ *\**) +\**((\w)+) *[,\)]/ ) {
				$ligne =~ s/$1/$2/;
			}
			$ligne =~ s/\*//g;
		}

		chomp($ligne);

		print "$prototype\n";
		print "{\n";
		print "\tD(bug(\"nfosmesa: $function_name\"));\n";
#		print "\tSelectContext(ctx);\n";
		print "\tfn.$ligne\n";
		print "}\n\n";

		$linecount++;
	}
}
close(FILE);
print "/* Functions generated: $linecount */\n";
