// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    Accessible, AccessibleRole, Align, Buildable, ConstraintTarget, InscriptionOverflow,
    LayoutManager, Overflow, Widget,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkInscription")]
    pub struct Inscription(Object<ffi::GtkInscription, ffi::GtkInscriptionClass>) @extends Widget, @implements Accessible, Buildable, ConstraintTarget;

    match fn {
        type_ => || ffi::gtk_inscription_get_type(),
    }
}

impl Inscription {
    #[doc(alias = "gtk_inscription_new")]
    pub fn new(text: Option<&str>) -> Inscription {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_inscription_new(text.to_glib_none().0)).unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Inscription`] objects.
    ///
    /// This method returns an instance of [`InscriptionBuilder`](crate::builders::InscriptionBuilder) which can be used to create [`Inscription`] objects.
    pub fn builder() -> InscriptionBuilder {
        InscriptionBuilder::new()
    }

    #[doc(alias = "gtk_inscription_get_attributes")]
    #[doc(alias = "get_attributes")]
    pub fn attributes(&self) -> Option<pango::AttrList> {
        unsafe { from_glib_none(ffi::gtk_inscription_get_attributes(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_inscription_get_min_chars")]
    #[doc(alias = "get_min_chars")]
    pub fn min_chars(&self) -> u32 {
        unsafe { ffi::gtk_inscription_get_min_chars(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_inscription_get_min_lines")]
    #[doc(alias = "get_min_lines")]
    pub fn min_lines(&self) -> u32 {
        unsafe { ffi::gtk_inscription_get_min_lines(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_inscription_get_nat_chars")]
    #[doc(alias = "get_nat_chars")]
    pub fn nat_chars(&self) -> u32 {
        unsafe { ffi::gtk_inscription_get_nat_chars(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_inscription_get_nat_lines")]
    #[doc(alias = "get_nat_lines")]
    pub fn nat_lines(&self) -> u32 {
        unsafe { ffi::gtk_inscription_get_nat_lines(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_inscription_get_text")]
    #[doc(alias = "get_text")]
    pub fn text(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gtk_inscription_get_text(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_inscription_get_text_overflow")]
    #[doc(alias = "get_text_overflow")]
    pub fn text_overflow(&self) -> InscriptionOverflow {
        unsafe {
            from_glib(ffi::gtk_inscription_get_text_overflow(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_inscription_get_wrap_mode")]
    #[doc(alias = "get_wrap_mode")]
    pub fn wrap_mode(&self) -> pango::WrapMode {
        unsafe { from_glib(ffi::gtk_inscription_get_wrap_mode(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_inscription_get_xalign")]
    #[doc(alias = "get_xalign")]
    pub fn xalign(&self) -> f32 {
        unsafe { ffi::gtk_inscription_get_xalign(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_inscription_get_yalign")]
    #[doc(alias = "get_yalign")]
    pub fn yalign(&self) -> f32 {
        unsafe { ffi::gtk_inscription_get_yalign(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_inscription_set_attributes")]
    pub fn set_attributes(&self, attrs: Option<&pango::AttrList>) {
        unsafe {
            ffi::gtk_inscription_set_attributes(self.to_glib_none().0, attrs.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_inscription_set_markup")]
    pub fn set_markup(&self, markup: Option<&str>) {
        unsafe {
            ffi::gtk_inscription_set_markup(self.to_glib_none().0, markup.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_inscription_set_min_chars")]
    pub fn set_min_chars(&self, min_chars: u32) {
        unsafe {
            ffi::gtk_inscription_set_min_chars(self.to_glib_none().0, min_chars);
        }
    }

    #[doc(alias = "gtk_inscription_set_min_lines")]
    pub fn set_min_lines(&self, min_lines: u32) {
        unsafe {
            ffi::gtk_inscription_set_min_lines(self.to_glib_none().0, min_lines);
        }
    }

    #[doc(alias = "gtk_inscription_set_nat_chars")]
    pub fn set_nat_chars(&self, nat_chars: u32) {
        unsafe {
            ffi::gtk_inscription_set_nat_chars(self.to_glib_none().0, nat_chars);
        }
    }

    #[doc(alias = "gtk_inscription_set_nat_lines")]
    pub fn set_nat_lines(&self, nat_lines: u32) {
        unsafe {
            ffi::gtk_inscription_set_nat_lines(self.to_glib_none().0, nat_lines);
        }
    }

    #[doc(alias = "gtk_inscription_set_text")]
    pub fn set_text(&self, text: Option<&str>) {
        unsafe {
            ffi::gtk_inscription_set_text(self.to_glib_none().0, text.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_inscription_set_text_overflow")]
    pub fn set_text_overflow(&self, overflow: InscriptionOverflow) {
        unsafe {
            ffi::gtk_inscription_set_text_overflow(self.to_glib_none().0, overflow.into_glib());
        }
    }

    #[doc(alias = "gtk_inscription_set_wrap_mode")]
    pub fn set_wrap_mode(&self, wrap_mode: pango::WrapMode) {
        unsafe {
            ffi::gtk_inscription_set_wrap_mode(self.to_glib_none().0, wrap_mode.into_glib());
        }
    }

    #[doc(alias = "gtk_inscription_set_xalign")]
    pub fn set_xalign(&self, xalign: f32) {
        unsafe {
            ffi::gtk_inscription_set_xalign(self.to_glib_none().0, xalign);
        }
    }

    #[doc(alias = "gtk_inscription_set_yalign")]
    pub fn set_yalign(&self, yalign: f32) {
        unsafe {
            ffi::gtk_inscription_set_yalign(self.to_glib_none().0, yalign);
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    #[doc(alias = "attributes")]
    pub fn connect_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_attributes_trampoline<F: Fn(&Inscription) + 'static>(
            this: *mut ffi::GtkInscription,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::attributes\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_attributes_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    #[doc(alias = "markup")]
    pub fn connect_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_markup_trampoline<F: Fn(&Inscription) + 'static>(
            this: *mut ffi::GtkInscription,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::markup\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_markup_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    #[doc(alias = "min-chars")]
    pub fn connect_min_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_min_chars_trampoline<F: Fn(&Inscription) + 'static>(
            this: *mut ffi::GtkInscription,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::min-chars\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_min_chars_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    #[doc(alias = "min-lines")]
    pub fn connect_min_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_min_lines_trampoline<F: Fn(&Inscription) + 'static>(
            this: *mut ffi::GtkInscription,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::min-lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_min_lines_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    #[doc(alias = "nat-chars")]
    pub fn connect_nat_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_nat_chars_trampoline<F: Fn(&Inscription) + 'static>(
            this: *mut ffi::GtkInscription,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::nat-chars\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_nat_chars_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    #[doc(alias = "nat-lines")]
    pub fn connect_nat_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_nat_lines_trampoline<F: Fn(&Inscription) + 'static>(
            this: *mut ffi::GtkInscription,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::nat-lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_nat_lines_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    #[doc(alias = "text")]
    pub fn connect_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_trampoline<F: Fn(&Inscription) + 'static>(
            this: *mut ffi::GtkInscription,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_text_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    #[doc(alias = "text-overflow")]
    pub fn connect_text_overflow_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_overflow_trampoline<F: Fn(&Inscription) + 'static>(
            this: *mut ffi::GtkInscription,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::text-overflow\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_text_overflow_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    #[doc(alias = "wrap-mode")]
    pub fn connect_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_mode_trampoline<F: Fn(&Inscription) + 'static>(
            this: *mut ffi::GtkInscription,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_wrap_mode_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    #[doc(alias = "xalign")]
    pub fn connect_xalign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_xalign_trampoline<F: Fn(&Inscription) + 'static>(
            this: *mut ffi::GtkInscription,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::xalign\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_xalign_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    #[doc(alias = "yalign")]
    pub fn connect_yalign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_yalign_trampoline<F: Fn(&Inscription) + 'static>(
            this: *mut ffi::GtkInscription,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::yalign\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_yalign_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

#[cfg(feature = "v4_8")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
impl Default for Inscription {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Inscription`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct InscriptionBuilder {
    builder: glib::object::ObjectBuilder<'static, Inscription>,
}

impl InscriptionBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    pub fn attributes(self, attributes: &pango::AttrList) -> Self {
        Self {
            builder: self.builder.property("attributes", attributes.clone()),
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    pub fn markup(self, markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("markup", markup.into()),
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    pub fn min_chars(self, min_chars: u32) -> Self {
        Self {
            builder: self.builder.property("min-chars", min_chars),
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    pub fn min_lines(self, min_lines: u32) -> Self {
        Self {
            builder: self.builder.property("min-lines", min_lines),
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    pub fn nat_chars(self, nat_chars: u32) -> Self {
        Self {
            builder: self.builder.property("nat-chars", nat_chars),
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    pub fn nat_lines(self, nat_lines: u32) -> Self {
        Self {
            builder: self.builder.property("nat-lines", nat_lines),
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    pub fn text(self, text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("text", text.into()),
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    pub fn text_overflow(self, text_overflow: InscriptionOverflow) -> Self {
        Self {
            builder: self.builder.property("text-overflow", text_overflow),
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    pub fn wrap_mode(self, wrap_mode: pango::WrapMode) -> Self {
        Self {
            builder: self.builder.property("wrap-mode", wrap_mode),
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    pub fn xalign(self, xalign: f32) -> Self {
        Self {
            builder: self.builder.property("xalign", xalign),
        }
    }

    #[cfg(feature = "v4_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_8")))]
    pub fn yalign(self, yalign: f32) -> Self {
        Self {
            builder: self.builder.property("yalign", yalign),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Inscription`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Inscription {
        self.builder.build()
    }
}

impl fmt::Display for Inscription {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Inscription")
    }
}
