/*------------------------------------------------------------\
|                                                             |
| Tool    :                     FMI                           |
|                                                             |
| File    :                 fmi_optim.h                       |
|                                                             |
| Author  :                 Jacomme Ludovic                   |
|                                                             |
| Date    :                   04.12.96                        |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/

# ifndef FMI_OPTIM_H
# define FMI_OPTIM_H

/*------------------------------------------------------\
|                                                       |
|                      Fsm Flag                         |
|                                                       |
\------------------------------------------------------*/

# define FMI_CLASS     (long)( 0x0004 )

/*------------------------------------------------------------\
|                                                             |
|                            Macro                            |
|                                                             |
\------------------------------------------------------------*/

# define IsFmiClass( T )     ( (T)->FLAGS &  FMI_CLASS )
# define SetFmiClass( T )    ( (T)->FLAGS |=  FMI_CLASS )
# define ClearFmiClass( T )  ( (T)->FLAGS &= ~FMI_CLASS )

/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                        fmiclass                             |
|                                                             |
\------------------------------------------------------------*/


  typedef struct fmicelm_list
  {
    struct fmicelm_list  *NEXT;
    struct fsmstate_list *STATE;

  } fmicelm_list;

/*------------------------------------------------------------\
|                                                             |
|                        fmiclass_list                        |
|                                                             |
\------------------------------------------------------------*/

  typedef struct fmiclass_list
  {
    struct fmiclass_list *NEXT;
    struct fmicelm_list  *ELM;

  } fmiclass_list;




/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

extern fmiclass_list *classetete;

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/

  extern fsmfig_list *FmiOptimizeFsm();

# endif
