!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_dens
!! NAME 
!! calc_dens
!!
!! FUNCTION
!! Convert core density and pseudized core densisty
!! from densities read from uspp (divide them by 4Pi.r2)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  pawarray
!!    %coreden4pr2(rho_meshsz)= Core density multiplied by 4Pi.r2
!!    %tcoreden4pr2(rho_meshsz)= Pseudo core density multiplied by 4Pi.r2
!!  pawdata
!!    %factzero= Factor to compute value of functions at r=0
!!    %rad(big_meshsz)= Coordinates of the radial grid
!!  pshead
!!    %sph_meshsz= Dimension of radial mesh for spheres
!!  un_log= Unit number for log file (comments)
!!
!! OUTPUT
!!  pawps
!!    %coredens(pshead%core_meshsz) = Core density of the atom
!!    %tcoredens(pshead%core_meshsz)= Pseudo-core density of the atom
!!
!! SIDE EFFECTS
!!  pshead
!!    %core_meshsz= Dimension of radial mesh for core and tcore densities
!!
!! PARENTS
!!      uspp2abinit
!!
!! CHILDREN
!!
!! SOURCE

 subroutine calc_dens(pawarray,pawdata,pawps,pshead,un_log)

 use defs_basis
 use defs_pawps

 implicit none

!Arguments ------------------------------------
 integer :: un_log
!These types are defined in defs_pawps
 type(pawarray_type) :: pawarray
 type(pawdata_type)  :: pawdata
 type(pawps_type)    :: pawps
 type(pshead_type)   :: pshead

!Local variables-------------------------------
 real(dp) :: core_prec=1.d-8
 integer :: ir,isize

! *************************************************************************

!Evaluate coredens and tcoredens for r>0
 do ir=2,pshead%core_meshsz
  pawps%coredens(ir) = pawarray%coreden4pr2(ir)&
&                    / (four_pi*pawdata%rad(ir)**2)
  pawps%tcoredens(ir)= pawarray%tcoreden4pr2(ir)&
&                    / (four_pi*pawdata%rad(ir)**2)
 enddo

!Deduce coredensand tcoredens  at r=0
 pawps%coredens(1) =pawps%coredens(2) +pawdata%factzero*(pawps%coredens(2) -pawps%coredens(3))
 pawps%tcoredens(1)=pawps%tcoredens(2)+pawdata%factzero*(pawps%tcoredens(2)-pawps%tcoredens(3))

!Adjust mesh size for (t)core density in order to get it lower than given precision
 isize=pshead%sph_meshsz
 do ir=pshead%sph_meshsz,pshead%core_meshsz
  if (abs(pawps%coredens(ir))>core_prec) isize=ir
 enddo
 pshead%core_meshsz=max(isize,pshead%sph_meshsz)
 if (pshead%core_meshsz>pshead%sph_meshsz) then
  write(un_log,'(/,a)') '> USpp->Abinit translator INFO:'
  write(un_log,'(a,i4,/,a,g9.2,a)') &
&   '  Mesh size for core density has been adjusted to ',pshead%core_meshsz,&
&   '  in order to get it lower than given precision (',core_prec,').'
 endif

end subroutine
!!***
