#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 Erwann Duclos
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2023 HS-157
set -o errexit

###
# Baba Is You
# send your bug reports to contact@dotslashplay.it
###

script_version=20240804.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='baba-is-you'
GAME_NAME='Baba Is You'

ARCHIVE_BASE_1_NAME='BIY_linux.tar.gz'
ARCHIVE_BASE_1_MD5='d32487c5a6789c6c6b24064088708cab'
ARCHIVE_BASE_1_SIZE='121230'
ARCHIVE_BASE_1_VERSION='478f-itch.2024.02.24'
ARCHIVE_BASE_1_URL='https://hempuli.itch.io/baba'

## Support for this archive is disabled until ./play.it can handle name collisions,
## cf. https://forge.dotslashplay.it/play.it/scripts/-/issues/355
#ARCHIVE_BASE_0_NAME='BIY_linux.tar.gz'
#ARCHIVE_BASE_0_MD5='555d408a45b47d68042bb82e9a2ebcfc'
#ARCHIVE_BASE_0_SIZE='150000'
#ARCHIVE_BASE_0_VERSION='477-itch.2023.03.07'

CONTENT_PATH_DEFAULT='Baba Is You'
CONTENT_GAME_BIN64_PATH="${CONTENT_PATH_DEFAULT}/bin64"
CONTENT_GAME_BIN64_FILES='
Chowdren'
CONTENT_GAME_BIN32_PATH="${CONTENT_PATH_DEFAULT}/bin32"
CONTENT_GAME_BIN32_FILES='
Chowdren'
CONTENT_GAME_DATA_FILES='
Data
icon.bmp
Assets.dat
gamecontrollerdb.txt'

APP_MAIN_EXE_BIN64='Chowdren'
APP_MAIN_EXE_BIN32='Chowdren'
APP_MAIN_ICON='icon.bmp'
## Work around the shipped SDL lack of support for Wayland.
## Using system-provided SDL is not an option because with it the game fails to render anything, with the following error:
## Could not create OpenGL context: Could not create EGL context (call to eglCreateContext failed, reporting an error of EGL_BAD_ATTRIBUTE)
APP_MAIN_PRERUN="${APP_MAIN_PRERUN:-}"'
# Work around the shipped SDL lack of support for Wayland
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libGL.so.1
libm.so.6
libpthread.so.0'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
