#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# What Remains of Edith Finch
# send your bug reports to contact@dotslashplay.it
###

script_version=20230406.1

GAME_ID='what-remains-of-edith-finch'
GAME_NAME='What Remains of Edith Finch'

ARCHIVE_BASE_0='setup_what_remains_of_edith_finch_1.0.0.0_(16929).exe'
ARCHIVE_BASE_0_MD5='ec155243055cbd820f8f9056eea5eb10'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_what_remains_of_edith_finch_1.0.0.0_(16929)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='f1a06506b6899cb72d44be1b8d6f7f44'
ARCHIVE_BASE_0_SIZE='2700000'
ARCHIVE_BASE_0_VERSION='1.0.0.0-gog16929'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/what_remains_of_edith_finch'

UNREALENGINE4_NAME='finchgame'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES="
engine
${UNREALENGINE4_NAME}/binaries
${UNREALENGINE4_NAME}/plugins
startwroef.exe"
CONTENT_GAME_DATA_FILES="
${UNREALENGINE4_NAME}"

WINE_DIRECT3D_RENDERER='dxvk'

APP_WINE_LINK_DIRS="
userdata:users/\${USER}/AppData/Local/${UNREALENGINE4_NAME}/Saved"
USER_PERSISTENT_DIRECTORIES='
userdata/Config/WindowsNoEditor
userdata/SaveGames'

APP_MAIN_EXE="${UNREALENGINE4_NAME}/binaries/win64/${UNREALENGINE4_NAME}-win64-shipping.exe"
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=123'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPS_ARCH='gst-plugins-base gst-plugins-good gst-libav'
PKG_BIN_DEPS_DEB='gstreamer1.0-plugins-base, gstreamer1.0-plugins-good, gstreamer1.0-libav'
PKG_BIN_DEPS_GENTOO='media-libs/gst-plugins-base media-plugins/gst-plugins-good media-libs/gst-plugins-libav'

# Load common functions

target_version='2.22'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
