#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Shelter 2
# Support for the Mountains stand-alone expansion is included
# send your bug reports to contact@dotslashplay.it
###

script_version=20230625.1

# Set game-specific variables

GAME_ID='shelter-2'
GAME_NAME='Shelter 2'

ARCHIVES_LIST='ARCHIVE_MOUNTAINS_GOG ARCHIVE_GOG'

ARCHIVE_MOUNTAINS_GOG='gog_shelter_2_mountains_dlc_2.0.0.1.sh'
ARCHIVE_MOUNTAINS_GOG_URL='https://www.gog.com/game/shelter_2_mountains'
ARCHIVE_MOUNTAINS_GOG_MD5='ffe25b4ac5d75b9a30ed983634397d85'
ARCHIVE_MOUNTAINS_GOG_SIZE='2500000'
ARCHIVE_MOUNTAINS_GOG_VERSION='1.0-gog2.0.0.1'

ARCHIVE_GOG='gog_shelter_2_2.5.0.10.sh'
ARCHIVE_GOG_URL='https://www.gog.com/game/shelter_2'
ARCHIVE_GOG_MD5='f2bf2e188667133ad117b5bff846e66e'
ARCHIVE_GOG_SIZE='2200000'
ARCHIVE_GOG_VERSION='20150708-gog2.5.0.10'

DATA_DIRS='./logs'

ARCHIVE_GAME_BIN_PATH='data/noarch/game'
ARCHIVE_GAME_BIN_FILES='Shelter2.x86 Shelter2_Data/Mono Shelter2_Data/Plugins'

ARCHIVE_GAME_DATA_PATH='data/noarch/game'
ARCHIVE_GAME_DATA_FILES='Shelter2_Data'

APP_MAIN_TYPE='native'
APP_MAIN_EXE='Shelter2.x86'
# shellcheck disable=SC2016
APP_MAIN_OPTIONS='-logFile ./logs/$(date +%F-%R).log'
APP_MAIN_ICON='Shelter2_Data/Resources/UnityPlayer.png'

PACKAGES_LIST='PKG_DATA PKG_BIN'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID glibc libstdc++ glu glx xcursor gtk2 alsa"
PKG_BIN_DEPS_ARCH='lib32-libx11 lib32-gdk-pixbuf2 lib32-glib2'
PKG_BIN_DEPS_DEB='libx11-6, libgdk-pixbuf2.0-0, libglib2.0-0'
PKG_BIN_DEPS_GENTOO='x11-libs/libX11[abi_x86_32] x11-libs/gdk-pixbuf[abi_x86_32] dev-libs/glib[abi_x86_32]'

# Load common functions

target_version='2.11'

if [ -z "$PLAYIT_LIB2" ]; then
	: "${XDG_DATA_HOME:="$HOME/.local/share"}"
	for path in\
		"$PWD"\
		"$XDG_DATA_HOME/play.it"\
		'/usr/local/share/games/play.it'\
		'/usr/local/share/play.it'\
		'/usr/share/games/play.it'\
		'/usr/share/play.it'
	do
		if [ -e "$path/libplayit2.sh" ]; then
			PLAYIT_LIB2="$path/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=play.it-2/lib/libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout
rm --recursive "$PLAYIT_WORKDIR/gamedata"

# Get game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
