#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Anna Lea
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Thimbleweed Park
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241111.2

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='thimbleweed-park'
GAME_NAME='Thimbleweed Park'

ARCHIVE_BASE_0_NAME='thimbleweed_park_en_1_0_958_19330.sh'
ARCHIVE_BASE_0_MD5='2803fd41a66c1163f02b61bb6ff286ab'
ARCHIVE_BASE_0_SIZE='943598'
ARCHIVE_BASE_0_VERSION='1.0.958-gog19330'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/thimbleweed_park'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN_FILES='
ThimbleweedPark'
CONTENT_GAME_DATA_FILES='
Icon*.png
ThimbleweedPark.ggpack?'

APP_MAIN_EXE='ThimbleweedPark'
APP_MAIN_ICONS_LIST='APP_MAIN_ICON_32 APP_MAIN_ICON_64 APP_MAIN_ICON_256 APP_MAIN_ICON_512 APP_MAIN_ICON_1024'
APP_MAIN_ICON_32='Icon32.png'
APP_MAIN_ICON_64='Icon64.png'
APP_MAIN_ICON_256='Icon256.png'
APP_MAIN_ICON_512='Icon512.png'
APP_MAIN_ICON_1024='Icon1024.png'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libGL.so.1
libm.so.6
libpthread.so.0
libstdc++.so.6'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
