#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Order of the Thorne
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250520.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='order-of-the-thorne'
GAME_NAME='Order of the Thorne: The Kingʼs Challenge'

ARCHIVE_BASE_LINUX_0_NAME='gog_order_of_the_thorne_the_king_s_challenge_2.0.0.1.sh'
ARCHIVE_BASE_LINUX_0_MD5='16dde031dcfb730be1d94bde77306b0d'
ARCHIVE_BASE_LINUX_0_SIZE='781609'
ARCHIVE_BASE_LINUX_0_VERSION='1.0-gog2.0.0.1'
ARCHIVE_BASE_LINUX_0_URL='https://www.gog.com/game/order_of_the_thorne_the_kings_challenge'

ARCHIVE_BASE_WINDOWS_0_NAME='setup_order_of_the_thorne_2.1.0.4.exe'
ARCHIVE_BASE_WINDOWS_0_MD5='f5dfd92a72167c9d033e0ca2c0262c79'
ARCHIVE_BASE_WINDOWS_0_SIZE='825998'
ARCHIVE_BASE_WINDOWS_0_VERSION='1.0-gog2.1.0.4'
ARCHIVE_BASE_WINDOWS_0_URL='https://www.gog.com/game/order_of_the_thorne_the_kings_challenge'

CONTENT_PATH_DEFAULT_LINUX='data/noarch/game'
CONTENT_PATH_DEFAULT_WINDOWS='app'
CONTENT_GAME_MAIN_FILES='
acsetup.cfg
*.vox'
CONTENT_GAME0_MAIN_FILES_LINUX='
agsgame.dat
modules.lst'
CONTENT_GAME0_MAIN_FILES_WINDOWS='
oott-tkc.exe'
CONTENT_DOC_MAIN_FILES_LINUX='
licenses'

APP_MAIN_SCUMMID='ags:oott'
APP_MAIN_ICON_LINUX='oott-tkc.png'
APP_MAIN_ICON_WINDOWS='oott-tkc.exe'

PKG_MAIN_ID="$GAME_ID"
PKG_MAIN_ID_LINUX="${PKG_MAIN_ID}-linux"
PKG_MAIN_ID_WINDOWS="${PKG_MAIN_ID}-windows"
PKG_MAIN_PROVIDES="
$PKG_MAIN_ID"
## Ensure easy upgrades from pre-20250520.2 packages
PKG_MAIN_PROVIDES="${PKG_MAIN_PROVIDES:-}
order-of-the-thorne-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
