/*###############################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_PCICapabilities.h"

CMPIObjectPath* PCI_OpenDRIM_PCICapabilities_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_PCICapabilities& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_PCICapabilities_classnames[0], OpenDRIM_PCICapabilities_NAMESPACE);

	if (!instance.ManagedElement_isNULL)
		op.addKey("ManagedElement", instance.ManagedElement);

	if (!instance.Capabilities_isNULL)
		op.addKey("Capabilities", instance.Capabilities);

	_L_;
	return op.getHdl();
}

CMPIInstance* PCI_OpenDRIM_PCICapabilities_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_PCICapabilities& instance) {
	_E_;
	Objectpath op(broker, PCI_OpenDRIM_PCICapabilities_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Characteristics_isNULL)
		ci.setProperty("Characteristics", instance.Characteristics);

	_L_;
	return ci.getHdl();
}

void PCI_OpenDRIM_PCICapabilities_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_PCICapabilities& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("Capabilities", instance.Capabilities) == OK)
		instance.Capabilities_isNULL = false;

	if (op.getKey("ManagedElement", instance.ManagedElement) == OK)
		instance.ManagedElement_isNULL = false;

	_L_;
}

void PCI_OpenDRIM_PCICapabilities_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_PCICapabilities& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("ManagedElement", instance.ManagedElement) == OK)
		instance.ManagedElement_isNULL = false;

	if (inst.getProperty("Capabilities", instance.Capabilities) == OK)
		instance.Capabilities_isNULL = false;

	if (inst.getProperty("Characteristics", instance.Characteristics) == OK)
		instance.Characteristics_isNULL = false;

	_L_;
}

