/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import java.io.IOException;

public class PPMMarkerSegment
extends MarkerSegment {
    public PPMMarkerSegment() {
        this._ccs.setPPMSeen(true);
    }

    @Override
    protected boolean process(int n) throws IOException {
        int n2 = ModuleBase.readUnsignedByte(this._dstream, this._module);
        --n;
        while (n > 0) {
            long l = this._module.readUnsignedInt(this._dstream);
            if (l > (long)(n -= 4)) {
                this._repInfo.setMessage(new ErrorMessage("Invalid length for tile-part header in PPM packet"));
                return false;
            }
            this._cs.addPPMLength(l);
            this._module.skipBytes(this._dstream, (int)l, this._module);
            n = (int)((long)n - l);
        }
        return true;
    }
}

