/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ChannelDefBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CodestreamRegBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ColorGroupBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.IPRBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.LabelBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.OpacityBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ResolutionBox;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ComposLayerHdrBox
extends JP2Box {
    private Property label;
    private Property opacityProp;
    private Property channelDefProp;
    private Property codestreamRegProp;
    private List colorSpecs;

    public ComposLayerHdrBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    @Override
    public boolean readBox() throws IOException {
        if (this._parentBox != null) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        this.hasBoxes = true;
        this.colorSpecs = new LinkedList();
        int n = (int)this._boxHeader.getDataLength();
        boolean bl = false;
        JP2Box jP2Box = null;
        boolean bl2 = false;
        boolean bl3 = false;
        while (this.hasNext() && (jP2Box = (JP2Box)this.next()) != null) {
            if (jP2Box instanceof ColorGroupBox || jP2Box instanceof OpacityBox || jP2Box instanceof ChannelDefBox || jP2Box instanceof CodestreamRegBox || jP2Box instanceof IPRBox || jP2Box instanceof ResolutionBox || jP2Box instanceof LabelBox) {
                if (!jP2Box.readBox()) {
                    return false;
                }
                if (jP2Box instanceof OpacityBox) {
                    bl2 = true;
                } else if (jP2Box instanceof ChannelDefBox) {
                    bl3 = true;
                }
                if (!(jP2Box instanceof LabelBox)) continue;
                this.label = new Property("Label", PropertyType.STRING, ((LabelBox)jP2Box).getLabel());
                continue;
            }
            jP2Box.skipBox();
        }
        if (bl2 && bl3) {
            this._repInfo.setMessage(new ErrorMessage("Compositing Layer Header may not have both Opacity and Channel Definition Boxes", this._module.getFilePos()));
            this._repInfo.setValid(false);
        }
        this.finalizeBytesRead();
        ArrayList<Property> arrayList = new ArrayList<Property>(4);
        if (this.label != null) {
            arrayList.add(this.label);
        }
        if (!this.colorSpecs.isEmpty()) {
            arrayList.add(new Property("ColorSpecs", PropertyType.PROPERTY, PropertyArity.LIST, this.colorSpecs));
        }
        if (this.opacityProp != null) {
            arrayList.add(this.opacityProp);
        }
        if (this.channelDefProp != null) {
            arrayList.add(this.channelDefProp);
        }
        if (this.codestreamRegProp != null) {
            arrayList.add(this.codestreamRegProp);
        }
        this._module.addComposLayer(new Property("CompositeLayerHeader", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        return true;
    }

    protected void addColorSpec(Property property) {
        this.colorSpecs.add(property);
    }

    protected void addOpacity(Property property) {
        this.opacityProp = property;
    }

    protected void addChannelDef(Property property) {
        this.channelDefProp = property;
    }

    protected void addCodestreamReg(Property property) {
        this.codestreamRegProp = property;
    }

    @Override
    protected String getSelfPropName() {
        return "Compositing Layer Header Box";
    }
}

