/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import picard.PicardException;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.RExecutor;

@CommandLineProgramProperties(usage="Program to generate a data table and pdf chart of mean base quality by cycle from a SAM or BAM file.  Works best on a single lane/run of data, but can be applied tomerged BAMs. Uses R to generate chart output.", usageShort="Writes mean quality by cycle for a SAM or BAM file", programGroup=Metrics.class)
public class MeanQualityByCycle
extends SinglePassSamProgram {
    @Option(shortName="CHART", doc="A file (with .pdf extension) to write the chart to.")
    public File CHART_OUTPUT;
    @Option(doc="If set to true, calculate mean quality over aligned reads only.")
    public boolean ALIGNED_READS_ONLY = false;
    @Option(doc="If set to true calculate mean quality over PF reads only.")
    public boolean PF_READS_ONLY = false;
    private final HistogramGenerator q = new HistogramGenerator(false);
    private final HistogramGenerator oq = new HistogramGenerator(true);
    private String plotSubtitle = "";
    private final Log log = Log.getInstance(MeanQualityByCycle.class);

    public static void main(String[] args) {
        System.exit(new MeanQualityByCycle().instanceMain(args));
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        IOUtil.assertFileIsWritable((File)this.CHART_OUTPUT);
        List readGroups = header.getReadGroups();
        if (readGroups.size() == 1) {
            this.plotSubtitle = StringUtil.asEmptyIfNull((Object)((SAMReadGroupRecord)readGroups.get(0)).getLibrary());
        }
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        if (this.PF_READS_ONLY && rec.getReadFailsVendorQualityCheckFlag()) {
            return;
        }
        if (this.ALIGNED_READS_ONLY && rec.getReadUnmappedFlag()) {
            return;
        }
        if (rec.isSecondaryOrSupplementary()) {
            return;
        }
        this.q.addRecord(rec);
        this.oq.addRecord(rec);
    }

    @Override
    protected void finish() {
        MetricsFile metrics = this.getMetricsFile();
        metrics.addHistogram(this.q.getMeanQualityHistogram());
        if (!this.oq.isEmpty()) {
            metrics.addHistogram(this.oq.getMeanQualityHistogram());
        }
        metrics.write(this.OUTPUT);
        if (this.q.isEmpty() && this.oq.isEmpty()) {
            this.log.warn(new Object[]{"No valid bases found in input file. No plot will be produced."});
        } else {
            int rResult = RExecutor.executeFromClasspath("picard/analysis/meanQualityByCycle.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), this.INPUT.getName(), this.plotSubtitle);
            if (rResult != 0) {
                throw new PicardException("R script meanQualityByCycle.R failed with return code " + rResult);
            }
        }
    }

    private static class HistogramGenerator {
        final boolean useOriginalQualities;
        int maxLengthSoFar = 0;
        double[] firstReadTotalsByCycle = new double[this.maxLengthSoFar];
        long[] firstReadCountsByCycle = new long[this.maxLengthSoFar];
        double[] secondReadTotalsByCycle = new double[this.maxLengthSoFar];
        long[] secondReadCountsByCycle = new long[this.maxLengthSoFar];

        private HistogramGenerator(boolean useOriginalQualities) {
            this.useOriginalQualities = useOriginalQualities;
        }

        void addRecord(SAMRecord rec) {
            byte[] quals;
            byte[] byArray = quals = this.useOriginalQualities ? rec.getOriginalBaseQualities() : rec.getBaseQualities();
            if (quals == null) {
                return;
            }
            int length = quals.length;
            boolean rc = rec.getReadNegativeStrandFlag();
            this.ensureArraysBigEnough(length + 1);
            for (int i = 0; i < length; ++i) {
                int cycle;
                int n = cycle = rc ? length - i : i + 1;
                if (rec.getReadPairedFlag() && rec.getSecondOfPairFlag()) {
                    int n2 = cycle;
                    this.secondReadTotalsByCycle[n2] = this.secondReadTotalsByCycle[n2] + (double)quals[i];
                    int n3 = cycle;
                    this.secondReadCountsByCycle[n3] = this.secondReadCountsByCycle[n3] + 1L;
                    continue;
                }
                int n4 = cycle;
                this.firstReadTotalsByCycle[n4] = this.firstReadTotalsByCycle[n4] + (double)quals[i];
                int n5 = cycle;
                this.firstReadCountsByCycle[n5] = this.firstReadCountsByCycle[n5] + 1L;
            }
        }

        private void ensureArraysBigEnough(int length) {
            if (length > this.maxLengthSoFar) {
                this.firstReadTotalsByCycle = Arrays.copyOf(this.firstReadTotalsByCycle, length);
                this.firstReadCountsByCycle = Arrays.copyOf(this.firstReadCountsByCycle, length);
                this.secondReadTotalsByCycle = Arrays.copyOf(this.secondReadTotalsByCycle, length);
                this.secondReadCountsByCycle = Arrays.copyOf(this.secondReadCountsByCycle, length);
                this.maxLengthSoFar = length;
            }
        }

        Histogram<Integer> getMeanQualityHistogram() {
            String label = this.useOriginalQualities ? "MEAN_ORIGINAL_QUALITY" : "MEAN_QUALITY";
            Histogram meanQualities = new Histogram("CYCLE", label);
            int firstReadLength = 0;
            for (int cycle = 0; cycle < this.firstReadTotalsByCycle.length; ++cycle) {
                if (!(this.firstReadTotalsByCycle[cycle] > 0.0)) continue;
                meanQualities.increment((Comparable)Integer.valueOf(cycle), this.firstReadTotalsByCycle[cycle] / (double)this.firstReadCountsByCycle[cycle]);
                firstReadLength = cycle;
            }
            for (int i = 0; i < this.secondReadTotalsByCycle.length; ++i) {
                if (this.secondReadCountsByCycle[i] <= 0L) continue;
                int cycle = firstReadLength + i;
                meanQualities.increment((Comparable)Integer.valueOf(cycle), this.secondReadTotalsByCycle[i] / (double)this.secondReadCountsByCycle[i]);
            }
            return meanQualities;
        }

        boolean isEmpty() {
            return this.maxLengthSoFar == 0;
        }
    }
}

