/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class BranchTargetFinder
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    public static final int UNKNOWN = -1;
    public static final int NO_SUBROUTINE = -2;
    private static final short INSTRUCTION = 1;
    private static final short CREATION = 2;
    private static final short INITIALIZER = 4;
    private static final short BRANCH_ORIGIN = 8;
    private static final short BRANCH_TARGET = 16;
    private static final short AFTER_BRANCH = 32;
    private static final short EXCEPTION_START = 64;
    private static final short EXCEPTION_END = 128;
    private static final short EXCEPTION_HANDLER = 256;
    private static final short SUBROUTINE_INVOCATION = 512;
    private static final short SUBROUTINE_RETURNING = 1024;
    private short[] instructionMarks = new short[8097];
    private int[] subroutineStarts = new int[8096];
    private int[] subroutineEnds = new int[8096];
    private boolean containsSubroutines;
    private boolean repeat;
    private int currentSubroutineStart;
    private boolean isInitializer;

    public boolean isInstruction(int n) {
        return (this.instructionMarks[n] & 1) != 0;
    }

    public boolean isCreation(int n) {
        return (this.instructionMarks[n] & 2) != 0;
    }

    public boolean isInitializer(int n) {
        return (this.instructionMarks[n] & 4) != 0;
    }

    public boolean isTarget(int n) {
        return n == 0 || (this.instructionMarks[n] & 0x1D0) != 0;
    }

    public boolean isBranchOrigin(int n) {
        return (this.instructionMarks[n] & 8) != 0;
    }

    public boolean isBranchTarget(int n) {
        return (this.instructionMarks[n] & 0x10) != 0;
    }

    public boolean isAfterBranch(int n) {
        return (this.instructionMarks[n] & 0x20) != 0;
    }

    public boolean isExceptionStart(int n) {
        return (this.instructionMarks[n] & 0x40) != 0;
    }

    public boolean isExceptionEnd(int n) {
        return (this.instructionMarks[n] & 0x80) != 0;
    }

    public boolean isExceptionHandler(int n) {
        return (this.instructionMarks[n] & 0x100) != 0;
    }

    public boolean isSubroutineInvocation(int n) {
        return (this.instructionMarks[n] & 0x200) != 0;
    }

    public boolean isSubroutineStart(int n) {
        return this.subroutineStarts[n] == n;
    }

    public boolean isSubroutine(int n) {
        return this.subroutineStarts[n] >= 0;
    }

    public boolean isSubroutineReturning(int n) {
        return (this.instructionMarks[n] & 0x400) != 0;
    }

    public int subroutineStart(int n) {
        return this.subroutineStarts[n];
    }

    public int subroutineEnd(int n) {
        return this.subroutineEnds[n];
    }

    public boolean containsSubroutines() {
        return this.containsSubroutines;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int n = codeAttribute.u4codeLength;
        if (this.subroutineStarts.length < n) {
            this.instructionMarks = new short[n + 1];
            this.subroutineStarts = new int[n];
            this.subroutineEnds = new int[n];
            Arrays.fill(this.subroutineStarts, 0, n, -1);
            Arrays.fill(this.subroutineEnds, 0, n, -1);
        } else {
            Arrays.fill(this.instructionMarks, 0, n, (short)0);
            Arrays.fill(this.subroutineStarts, 0, n, -1);
            Arrays.fill(this.subroutineEnds, 0, n, -1);
            this.instructionMarks[n] = 0;
        }
        this.containsSubroutines = false;
        do {
            this.repeat = false;
            this.currentSubroutineStart = -2;
            codeAttribute.instructionsAccept(clazz, method, this);
            codeAttribute.exceptionsAccept(clazz, method, this);
        } while (this.repeat);
        this.instructionMarks[n] = 16;
        if (this.containsSubroutines) {
            int n2;
            int n3;
            int n4 = -2;
            for (n3 = 0; n3 < n; ++n3) {
                if (!this.isInstruction(n3)) continue;
                n2 = this.subroutineStarts[n3];
                if (n2 >= 0 && this.isSubroutineReturning(n3)) {
                    int n5 = n2;
                    this.instructionMarks[n5] = (short)(this.instructionMarks[n5] | 0x400);
                }
                if (n4 >= 0) {
                    this.subroutineEnds[n4] = n3;
                }
                n4 = n2;
            }
            if (n4 >= 0) {
                this.subroutineEnds[n4] = n;
            }
            for (n3 = 0; n3 < n; ++n3) {
                if (!this.isSubroutine(n3)) continue;
                n2 = this.subroutineStarts[n3];
                if (this.isSubroutineReturning(n2)) {
                    int n6 = n3;
                    this.instructionMarks[n6] = (short)(this.instructionMarks[n6] | 0x400);
                }
                this.subroutineEnds[n3] = this.subroutineEnds[n2];
            }
        }
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        int n2 = n;
        this.instructionMarks[n2] = (short)(this.instructionMarks[n2] | 1);
        this.checkSubroutine(n);
        byte by = simpleInstruction.opcode;
        if (by == -84 || by == -83 || by == -82 || by == -81 || by == -80 || by == -79 || by == -65) {
            this.markBranchOrigin(n);
            this.markAfterBranchOrigin(n + simpleInstruction.length(n));
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        int n2 = n;
        this.instructionMarks[n2] = (short)(this.instructionMarks[n2] | 1);
        this.checkSubroutine(n);
        byte by = constantInstruction.opcode;
        if (by == -69) {
            int n3 = n;
            this.instructionMarks[n3] = (short)(this.instructionMarks[n3] | 2);
        } else if (by == -73) {
            this.isInitializer = false;
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
            if (this.isInitializer) {
                int n4 = n;
                this.instructionMarks[n4] = (short)(this.instructionMarks[n4] | 4);
            }
        }
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        int n2 = n;
        this.instructionMarks[n2] = (short)(this.instructionMarks[n2] | 1);
        this.checkSubroutine(n);
        if (variableInstruction.opcode == -87) {
            this.containsSubroutines = true;
            this.markBranchOrigin(n);
            int n3 = n;
            this.instructionMarks[n3] = (short)(this.instructionMarks[n3] | 0x400);
            this.markAfterBranchOrigin(n + variableInstruction.length(n));
        }
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        int n2 = branchInstruction.branchOffset;
        int n3 = n + n2;
        this.markBranchOrigin(n);
        this.checkSubroutine(n);
        this.markBranchTarget(n, n2);
        byte by = branchInstruction.opcode;
        if (by == -88 || by == -55) {
            this.containsSubroutines = true;
            int n4 = n;
            this.instructionMarks[n4] = (short)(this.instructionMarks[n4] | 0x200);
            this.markBranchSubroutineStart(n, n2, n3);
        } else if (this.currentSubroutineStart != -1) {
            this.markBranchSubroutineStart(n, n2, this.currentSubroutineStart);
        }
        if (by == -89 || by == -56) {
            this.markAfterBranchOrigin(n + branchInstruction.length(n));
        }
    }

    @Override
    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SwitchInstruction switchInstruction) {
        this.markBranchOrigin(n);
        this.checkSubroutine(n);
        this.markBranch(n, switchInstruction.defaultOffset);
        this.markBranches(n, switchInstruction.jumpOffsets);
        this.markAfterBranchOrigin(n + switchInstruction.length(n));
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        this.isInitializer = methodrefConstant.getName(clazz).equals("<init>");
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        int n = exceptionInfo.u2startPC;
        int n2 = exceptionInfo.u2endPC;
        int n3 = exceptionInfo.u2handlerPC;
        int n4 = n;
        this.instructionMarks[n4] = (short)(this.instructionMarks[n4] | 0x40);
        int n5 = n2;
        this.instructionMarks[n5] = (short)(this.instructionMarks[n5] | 0x80);
        int n6 = n3;
        this.instructionMarks[n6] = (short)(this.instructionMarks[n6] | 0x100);
        if (this.subroutineStarts[n3] == -1 && this.subroutineStarts[n] != -1) {
            this.subroutineStarts[n3] = this.subroutineStarts[n];
            this.repeat = true;
        }
    }

    private void markBranches(int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.markBranch(n, nArray[i]);
        }
    }

    private void markBranch(int n, int n2) {
        this.markBranchTarget(n, n2);
        if (this.currentSubroutineStart != -1) {
            this.markBranchSubroutineStart(n, n2, this.currentSubroutineStart);
        }
    }

    private void markBranchOrigin(int n) {
        int n2 = n;
        this.instructionMarks[n2] = (short)(this.instructionMarks[n2] | 9);
    }

    private void markBranchTarget(int n, int n2) {
        int n3;
        int n4 = n3 = n + n2;
        this.instructionMarks[n4] = (short)(this.instructionMarks[n4] | 0x10);
    }

    private void markBranchSubroutineStart(int n, int n2, int n3) {
        int n4 = n + n2;
        if (this.subroutineStarts[n4] == -1) {
            if (n2 < 0) {
                if (n3 > n4) {
                    n3 = n4;
                }
                this.repeat = true;
            }
            this.subroutineStarts[n4] = n3;
        }
    }

    private void markAfterBranchOrigin(int n) {
        int n2 = n;
        this.instructionMarks[n2] = (short)(this.instructionMarks[n2] | 0x20);
        this.currentSubroutineStart = -1;
    }

    private void checkSubroutine(int n) {
        if (this.subroutineStarts[n] != -1) {
            this.currentSubroutineStart = this.subroutineStarts[n];
        } else if (this.currentSubroutineStart != -1) {
            this.subroutineStarts[n] = this.currentSubroutineStart;
        }
    }
}

