/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class ParallelAllClassVisitor
implements ClassPoolVisitor {
    private static final int THREAD_COUNT;
    private final ClassVisitorFactory classVisitorFactory;

    public ParallelAllClassVisitor(ClassVisitorFactory classVisitorFactory) {
        this.classVisitorFactory = classVisitorFactory;
    }

    @Override
    public void visitClassPool(ClassPool classPool) {
        if (THREAD_COUNT <= 1) {
            classPool.classesAccept(this.classVisitorFactory.createClassVisitor());
        } else {
            ExecutorService executorService = Executors.newFixedThreadPool(THREAD_COUNT, new MyThreadFactory());
            MyThreadedClassVisitor myThreadedClassVisitor = new MyThreadedClassVisitor(executorService);
            classPool.classesAccept(myThreadedClassVisitor);
            try {
                executorService.shutdown();
                myThreadedClassVisitor.awaitTermination();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Parallel execution is taking too long", interruptedException);
            }
            catch (ExecutionException executionException) {
                throw new RuntimeException(executionException.getCause());
            }
        }
    }

    static {
        Integer n = null;
        try {
            String string = System.getProperty("parallel.threads");
            if (string != null) {
                n = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = n == null ? Runtime.getRuntime().availableProcessors() - 1 : Math.min(n, Runtime.getRuntime().availableProcessors());
        THREAD_COUNT = n;
    }

    private static class MyThreadedClassVisitor
    implements ClassVisitor {
        private final ExecutorService executorService;
        private final List<Future> futures = new ArrayList<Future>();

        public MyThreadedClassVisitor(ExecutorService executorService) {
            this.executorService = executorService;
        }

        public void awaitTermination() throws ExecutionException, InterruptedException {
            for (Future future : this.futures) {
                future.get();
            }
        }

        @Override
        public void visitLibraryClass(LibraryClass libraryClass) {
            this.submitClassToExecutorService(libraryClass);
        }

        @Override
        public void visitProgramClass(ProgramClass programClass) {
            this.submitClassToExecutorService(programClass);
        }

        private void submitClassToExecutorService(final Clazz clazz) {
            this.futures.add(this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    MyClassVisitorThread myClassVisitorThread = (MyClassVisitorThread)Thread.currentThread();
                    clazz.accept(myClassVisitorThread.classVisitor);
                }
            }));
        }
    }

    private class MyClassVisitorThread
    extends Thread {
        private final ClassVisitor classVisitor;

        public MyClassVisitorThread(int n, Runnable runnable) {
            super(runnable, "Parallel Class Visitor " + n);
            this.classVisitor = ParallelAllClassVisitor.this.classVisitorFactory.createClassVisitor();
        }
    }

    private class MyThreadFactory
    implements ThreadFactory {
        private int threadCounter = 0;

        private MyThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new MyClassVisitorThread(++this.threadCounter, runnable);
        }
    }

    public static interface ClassVisitorFactory {
        public ClassVisitor createClassVisitor();
    }
}

