/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.SidePaneUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.SidePaneGroup;
import com.jidesoft.swing.SidePaneItem;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class SidePane
extends JPanel
implements SwingConstants,
Accessible {
    private final List<SidePaneGroup> _groups = new ArrayList<SidePaneGroup>();
    private int _attachedSide;
    private boolean _rollover = true;
    private static final String uiClassID = "SidePaneUI";

    public SidePane(int n) {
        this.setAttachedSide(n);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
    }

    @Override
    public SidePaneUI getUI() {
        return (SidePaneUI)this.ui;
    }

    public void setUI(SidePaneUI sidePaneUI) {
        super.setUI(sidePaneUI);
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI((SidePaneUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void addGroup(SidePaneGroup sidePaneGroup) {
        this.getGroups().add(sidePaneGroup);
    }

    public void removeGroup(SidePaneGroup sidePaneGroup) {
        this.getGroups().remove(sidePaneGroup);
    }

    public void removeGroup(int n) {
        this.removeGroup(this.getGroups().get(n));
    }

    public List<SidePaneGroup> getGroups() {
        return this._groups;
    }

    public int getAttachedSide() {
        return this._attachedSide;
    }

    public void setAttachedSide(int n) {
        if (n != 1 && n != 5 && n != 7 && n != 3) {
            throw new IllegalArgumentException("illegal attached side: must be NORTH, SOUTH, WEST, or EAST");
        }
        this._attachedSide = n;
        this.updateUI();
    }

    public boolean isRollover() {
        return this._rollover;
    }

    public void setRollover(boolean bl) {
        this._rollover = bl;
        this.updateUI();
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        SidePaneItem sidePaneItem;
        int n;
        if (this.getUI() != null && !this.isRollover() && (n = this.getUI().getSelectedItemIndex(mouseEvent.getPoint())) != -1 && (sidePaneItem = this.getUI().getItemForIndex(n)) != null && sidePaneItem.getComponent() instanceof JComponent) {
            return ((JComponent)sidePaneItem.getComponent()).getToolTipText();
        }
        return null;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSidePane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleSidePane
    extends JPanel.AccessibleJPanel {
        private static final long serialVersionUID = -6914188774912169441L;

        protected AccessibleSidePane() {
            super(SidePane.this);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            return super.getAccessibleStateSet();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB_LIST;
        }
    }
}

