#!/usr/bin/python3

from urllib.parse import quote
from glob import glob
from json import dumps
from polib import pofile
from sys import argv

result = {}

for filename in glob('po/*.po'):
    po = pofile(filename,
                autodetect_encoding=False,
                encoding='utf-8',
                wrapwidth=-1)
    t = {}
    for entry in po:
        if entry.obsolete or entry.msgstr in ('', entry.msgid):
            continue
        t[entry.msgid] = entry.msgstr
    lang = filename[3:-3] # 'po/lang.po' -> 'lang'
    result[lang] = t

if '--debug' in argv:
    from pprint import pprint
    pprint(result)
else:
    print(quote(dumps(result, sort_keys=True)))
