--TEST--
Test parsing of quantities
--EXTENSIONS--
zend_test
--FILE--
<?php

// This test checks valid formats do not throw any warnings.
foreach (['', ' '] as $leadingWS) {
  foreach (['', '+', '-'] as $sign) {
    foreach (['', ' '] as $midWS) {
      foreach (['', 'K', 'k', 'M', 'm', 'G', 'g'] as $exp) {
        foreach (['', ' '] as $trailingWS) {
          // Decimal
          $setting = sprintf('%s%s1%s%s%s',
                             $leadingWS, $sign, $midWS, $exp, $trailingWS);
          printf("# \"%s\"\n", $setting);
          var_dump(zend_test_zend_ini_parse_quantity($setting));
          print "\n";

          if ($exp !== 'g' && $exp !== 'G') { // Would overflow
              // Octal
              $setting = sprintf('%s%s0123%s%s%s',
                                 $leadingWS, $sign, $midWS, $exp, $trailingWS);
              printf("# \"%s\"\n", $setting);
              var_dump(zend_test_zend_ini_parse_quantity($setting));
              print "\n";
          }
        }
      }
    }
  }
}
?>
--EXPECT--
# "1"
int(1)

# "0123"
int(83)

# "1 "
int(1)

# "0123 "
int(83)

# "1K"
int(1024)

# "0123K"
int(84992)

# "1K "
int(1024)

# "0123K "
int(84992)

# "1k"
int(1024)

# "0123k"
int(84992)

# "1k "
int(1024)

# "0123k "
int(84992)

# "1M"
int(1048576)

# "0123M"
int(87031808)

# "1M "
int(1048576)

# "0123M "
int(87031808)

# "1m"
int(1048576)

# "0123m"
int(87031808)

# "1m "
int(1048576)

# "0123m "
int(87031808)

# "1G"
int(1073741824)

# "1G "
int(1073741824)

# "1g"
int(1073741824)

# "1g "
int(1073741824)

# "1 "
int(1)

# "0123 "
int(83)

# "1  "
int(1)

# "0123  "
int(83)

# "1 K"
int(1024)

# "0123 K"
int(84992)

# "1 K "
int(1024)

# "0123 K "
int(84992)

# "1 k"
int(1024)

# "0123 k"
int(84992)

# "1 k "
int(1024)

# "0123 k "
int(84992)

# "1 M"
int(1048576)

# "0123 M"
int(87031808)

# "1 M "
int(1048576)

# "0123 M "
int(87031808)

# "1 m"
int(1048576)

# "0123 m"
int(87031808)

# "1 m "
int(1048576)

# "0123 m "
int(87031808)

# "1 G"
int(1073741824)

# "1 G "
int(1073741824)

# "1 g"
int(1073741824)

# "1 g "
int(1073741824)

# "+1"
int(1)

# "+0123"
int(83)

# "+1 "
int(1)

# "+0123 "
int(83)

# "+1K"
int(1024)

# "+0123K"
int(84992)

# "+1K "
int(1024)

# "+0123K "
int(84992)

# "+1k"
int(1024)

# "+0123k"
int(84992)

# "+1k "
int(1024)

# "+0123k "
int(84992)

# "+1M"
int(1048576)

# "+0123M"
int(87031808)

# "+1M "
int(1048576)

# "+0123M "
int(87031808)

# "+1m"
int(1048576)

# "+0123m"
int(87031808)

# "+1m "
int(1048576)

# "+0123m "
int(87031808)

# "+1G"
int(1073741824)

# "+1G "
int(1073741824)

# "+1g"
int(1073741824)

# "+1g "
int(1073741824)

# "+1 "
int(1)

# "+0123 "
int(83)

# "+1  "
int(1)

# "+0123  "
int(83)

# "+1 K"
int(1024)

# "+0123 K"
int(84992)

# "+1 K "
int(1024)

# "+0123 K "
int(84992)

# "+1 k"
int(1024)

# "+0123 k"
int(84992)

# "+1 k "
int(1024)

# "+0123 k "
int(84992)

# "+1 M"
int(1048576)

# "+0123 M"
int(87031808)

# "+1 M "
int(1048576)

# "+0123 M "
int(87031808)

# "+1 m"
int(1048576)

# "+0123 m"
int(87031808)

# "+1 m "
int(1048576)

# "+0123 m "
int(87031808)

# "+1 G"
int(1073741824)

# "+1 G "
int(1073741824)

# "+1 g"
int(1073741824)

# "+1 g "
int(1073741824)

# "-1"
int(-1)

# "-0123"
int(-83)

# "-1 "
int(-1)

# "-0123 "
int(-83)

# "-1K"
int(-1024)

# "-0123K"
int(-84992)

# "-1K "
int(-1024)

# "-0123K "
int(-84992)

# "-1k"
int(-1024)

# "-0123k"
int(-84992)

# "-1k "
int(-1024)

# "-0123k "
int(-84992)

# "-1M"
int(-1048576)

# "-0123M"
int(-87031808)

# "-1M "
int(-1048576)

# "-0123M "
int(-87031808)

# "-1m"
int(-1048576)

# "-0123m"
int(-87031808)

# "-1m "
int(-1048576)

# "-0123m "
int(-87031808)

# "-1G"
int(-1073741824)

# "-1G "
int(-1073741824)

# "-1g"
int(-1073741824)

# "-1g "
int(-1073741824)

# "-1 "
int(-1)

# "-0123 "
int(-83)

# "-1  "
int(-1)

# "-0123  "
int(-83)

# "-1 K"
int(-1024)

# "-0123 K"
int(-84992)

# "-1 K "
int(-1024)

# "-0123 K "
int(-84992)

# "-1 k"
int(-1024)

# "-0123 k"
int(-84992)

# "-1 k "
int(-1024)

# "-0123 k "
int(-84992)

# "-1 M"
int(-1048576)

# "-0123 M"
int(-87031808)

# "-1 M "
int(-1048576)

# "-0123 M "
int(-87031808)

# "-1 m"
int(-1048576)

# "-0123 m"
int(-87031808)

# "-1 m "
int(-1048576)

# "-0123 m "
int(-87031808)

# "-1 G"
int(-1073741824)

# "-1 G "
int(-1073741824)

# "-1 g"
int(-1073741824)

# "-1 g "
int(-1073741824)

# " 1"
int(1)

# " 0123"
int(83)

# " 1 "
int(1)

# " 0123 "
int(83)

# " 1K"
int(1024)

# " 0123K"
int(84992)

# " 1K "
int(1024)

# " 0123K "
int(84992)

# " 1k"
int(1024)

# " 0123k"
int(84992)

# " 1k "
int(1024)

# " 0123k "
int(84992)

# " 1M"
int(1048576)

# " 0123M"
int(87031808)

# " 1M "
int(1048576)

# " 0123M "
int(87031808)

# " 1m"
int(1048576)

# " 0123m"
int(87031808)

# " 1m "
int(1048576)

# " 0123m "
int(87031808)

# " 1G"
int(1073741824)

# " 1G "
int(1073741824)

# " 1g"
int(1073741824)

# " 1g "
int(1073741824)

# " 1 "
int(1)

# " 0123 "
int(83)

# " 1  "
int(1)

# " 0123  "
int(83)

# " 1 K"
int(1024)

# " 0123 K"
int(84992)

# " 1 K "
int(1024)

# " 0123 K "
int(84992)

# " 1 k"
int(1024)

# " 0123 k"
int(84992)

# " 1 k "
int(1024)

# " 0123 k "
int(84992)

# " 1 M"
int(1048576)

# " 0123 M"
int(87031808)

# " 1 M "
int(1048576)

# " 0123 M "
int(87031808)

# " 1 m"
int(1048576)

# " 0123 m"
int(87031808)

# " 1 m "
int(1048576)

# " 0123 m "
int(87031808)

# " 1 G"
int(1073741824)

# " 1 G "
int(1073741824)

# " 1 g"
int(1073741824)

# " 1 g "
int(1073741824)

# " +1"
int(1)

# " +0123"
int(83)

# " +1 "
int(1)

# " +0123 "
int(83)

# " +1K"
int(1024)

# " +0123K"
int(84992)

# " +1K "
int(1024)

# " +0123K "
int(84992)

# " +1k"
int(1024)

# " +0123k"
int(84992)

# " +1k "
int(1024)

# " +0123k "
int(84992)

# " +1M"
int(1048576)

# " +0123M"
int(87031808)

# " +1M "
int(1048576)

# " +0123M "
int(87031808)

# " +1m"
int(1048576)

# " +0123m"
int(87031808)

# " +1m "
int(1048576)

# " +0123m "
int(87031808)

# " +1G"
int(1073741824)

# " +1G "
int(1073741824)

# " +1g"
int(1073741824)

# " +1g "
int(1073741824)

# " +1 "
int(1)

# " +0123 "
int(83)

# " +1  "
int(1)

# " +0123  "
int(83)

# " +1 K"
int(1024)

# " +0123 K"
int(84992)

# " +1 K "
int(1024)

# " +0123 K "
int(84992)

# " +1 k"
int(1024)

# " +0123 k"
int(84992)

# " +1 k "
int(1024)

# " +0123 k "
int(84992)

# " +1 M"
int(1048576)

# " +0123 M"
int(87031808)

# " +1 M "
int(1048576)

# " +0123 M "
int(87031808)

# " +1 m"
int(1048576)

# " +0123 m"
int(87031808)

# " +1 m "
int(1048576)

# " +0123 m "
int(87031808)

# " +1 G"
int(1073741824)

# " +1 G "
int(1073741824)

# " +1 g"
int(1073741824)

# " +1 g "
int(1073741824)

# " -1"
int(-1)

# " -0123"
int(-83)

# " -1 "
int(-1)

# " -0123 "
int(-83)

# " -1K"
int(-1024)

# " -0123K"
int(-84992)

# " -1K "
int(-1024)

# " -0123K "
int(-84992)

# " -1k"
int(-1024)

# " -0123k"
int(-84992)

# " -1k "
int(-1024)

# " -0123k "
int(-84992)

# " -1M"
int(-1048576)

# " -0123M"
int(-87031808)

# " -1M "
int(-1048576)

# " -0123M "
int(-87031808)

# " -1m"
int(-1048576)

# " -0123m"
int(-87031808)

# " -1m "
int(-1048576)

# " -0123m "
int(-87031808)

# " -1G"
int(-1073741824)

# " -1G "
int(-1073741824)

# " -1g"
int(-1073741824)

# " -1g "
int(-1073741824)

# " -1 "
int(-1)

# " -0123 "
int(-83)

# " -1  "
int(-1)

# " -0123  "
int(-83)

# " -1 K"
int(-1024)

# " -0123 K"
int(-84992)

# " -1 K "
int(-1024)

# " -0123 K "
int(-84992)

# " -1 k"
int(-1024)

# " -0123 k"
int(-84992)

# " -1 k "
int(-1024)

# " -0123 k "
int(-84992)

# " -1 M"
int(-1048576)

# " -0123 M"
int(-87031808)

# " -1 M "
int(-1048576)

# " -0123 M "
int(-87031808)

# " -1 m"
int(-1048576)

# " -0123 m"
int(-87031808)

# " -1 m "
int(-1048576)

# " -0123 m "
int(-87031808)

# " -1 G"
int(-1073741824)

# " -1 G "
int(-1073741824)

# " -1 g"
int(-1073741824)

# " -1 g "
int(-1073741824)
