#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from oslo_policy import policy

from nova.policies import base


POLICY_ROOT = 'os_compute_api:os-server-shares:%s'


server_shares_policies = [
    policy.DocumentedRuleDefault(
        name=POLICY_ROOT % 'index',
        check_str=base.PROJECT_READER_OR_ADMIN,
        description="List all shares for given server",
        operations=[
            {
                'method': 'GET',
                'path': '/servers/{server_id}/shares'
            }
        ],
        scope_types=['project']),
    policy.DocumentedRuleDefault(
        name=POLICY_ROOT % 'create',
        check_str=base.PROJECT_MEMBER_OR_ADMIN,
        description="Attach a share to the specified server",
        operations=[
            {
                'method': 'POST',
                'path': '/servers/{server_id}/shares'
            }
        ],
        scope_types=['project']),
    policy.DocumentedRuleDefault(
        name=POLICY_ROOT % 'show',
        check_str=base.PROJECT_READER_OR_ADMIN,
        description="Show a share configured for the specified server",
        operations=[
            {
                'method': 'GET',
                'path': '/servers/{server_id}/shares/{share_id}'
            }
        ],
        scope_types=['project']),
    policy.DocumentedRuleDefault(
        name=POLICY_ROOT % 'delete',
        check_str=base.PROJECT_MEMBER_OR_ADMIN,
        description="Detach a share to the specified server",
        operations=[
            {
                'method': 'DELETE',
                'path': '/servers/{server_id}/shares/{share_id}'
            }
        ],
        scope_types=['project']),
]


def list_rules():
    return server_shares_policies
