.TH XvPortNotify __libmansuffix__  __vendorversion__ "libXv Functions"
.SH NAME
XvPortNotify \- event generated when port attributes change
.\"
.SH SYNOPSIS
.B #include <X11/extensions/Xvlib.h>
.br
.sp 1l
.EX

     typedef union {
       int type;
       XvVideoNotifyEvent xvvideo;
       XvPortNotifyEvent xvport;
       long pad[24];
     } XvEvent;

     typedef struct {
       int type;
       unsigned long serial;
       Bool send_event;
       Display *display;
       XvPortID port_id;
       Time time;
       Atom attribute;
       long value;
     } XvPortNotifyEvent;

.EE
.\"
.IP \fItype\fR 15
Specifies the type of event: XvPortNotify.
.IP \fIserial\fR 15
Number of the last request processed by the server.
.IP \fIsend_event\fR 15
True if the event was generated by a SendEvent request.
.IP \fIdisplay\fR 15
A pointer to the display the event was read from.
.IP \fIport_id\fR 15
The port whose attribute has changed.
.IP \fIattribute\fR 15
An atom specifying the attribute that changed.
.IP \fIvalue\fR 15
The new value of the attribute.
.\"
.SH DESCRIPTION
.\"
XvPortNotify events are generated when a port attribute is set using
the
.BR XvSetPortAttribute (__libmansuffix__)
function.
.\"
.SH SEE ALSO
.BR XvSetPortAttribute (__libmansuffix__),
.BR XvGetPortAttribute (__libmansuffix__),
.BR XvSelectPortNotify (__libmansuffix__).
.\"
