#ifndef __WEBAPP_INFO_H
#define __WEBAPP_INFO_H

#include <glib.h>

typedef struct _WebappInfo WebappInfo;

WebappInfo *webapp_info_new (const gchar *package_name);
void webapp_info_free (WebappInfo *info);

const gchar *webapp_info_get_package_name (WebappInfo *info);

void webapp_info_add_url (WebappInfo *info, const gchar *url);
GPtrArray *webapp_info_get_urls (WebappInfo *info);

void webapp_info_set_application_name (WebappInfo *info, const gchar *application_name);
const gchar *webapp_info_get_application_name (WebappInfo *info);
void webapp_info_set_application_domain (WebappInfo *info, const gchar *application_domain);
const gchar *webapp_info_get_application_domain (WebappInfo *info);

gboolean webapp_info_has_urls (WebappInfo *info);
gboolean webapp_info_verify (WebappInfo *info);

GVariant *webapp_info_serialize (WebappInfo *info);

#endif
