# LibreOffice help build

LibreOffice can build three kinds of help output from helpcontent2:

* XML (local, bundeled with LibreOffice < 6.0)
* HTML (local, bundeled with LibreOffice >= 6.0)
* HTML (online)

Both local help variants can be included in help-packs, which might be bundeled
with the installer or provided as separate packages. They are supposed to be
installed by a user to provide localized help. Both HTML-based help types are
displayed in a browser, while the XML help uses an internal viewer component.

The XML help is the only one supported in extensions.

## configure options

--with-help: selects the help type to build
--with-omindex: prepares the online help for a Xapian Omega based search index
--disable-xmlhelp: removes support for the XML help
--with-helppack-integration: includes the help-packs in the installer

Also see `configure --help`.

## XML help, bundeled

This type was bundeled per-default until LibreOffice 6.0.

This help output is generated by using two tools: HelpIndexer and HelpLinker.
It uses an internal viewer component. Extensions still use this help type to
ship their help. This output is originally based on JavaDoc.

The main support for this help type is in the following directories:

* helpcompiler: tooling and support library
* xmlhelp: the viewer component
* desktop/source/deployment/registry/help: extensions / help-pack support

Most code is "marked" by HAVE_FEATURE_XMLHELP precompiler blocks or conditioned
by the XMLHELP flag in the $BUILD_TYPE variable.

Interestingly the HelpIndexer and HelpLinker are used by gbuild to build the
help inside bundeled extensions, but both are not part of the LibreOffice SDK.

## HTML help, bundeled

This type is bundeled per-default since LibreOffice 6.0 and displayed in a
browser.

## HTML help, online

This help is the external one, currently provided by help.libreoffice.org. It
differs from the bundeled HTML help in three main aspects:

* has a language chooser widget
* provides an additional Xapian Omega, CGI- / server-based search index
* includes some additional multimedia assets

It is opened in a browser.
