// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/videointelligence/v1p1beta1/video_intelligence.proto

/*
Package videointelligence is a generated protocol buffer package.

It is generated from these files:
	google/cloud/videointelligence/v1p1beta1/video_intelligence.proto

It has these top-level messages:
	AnnotateVideoRequest
	VideoContext
	LabelDetectionConfig
	ShotChangeDetectionConfig
	ExplicitContentDetectionConfig
	FaceConfig
	VideoSegment
	LabelSegment
	LabelFrame
	Entity
	LabelAnnotation
	ExplicitContentFrame
	ExplicitContentAnnotation
	NormalizedBoundingBox
	FaceSegment
	FaceDetectionFrame
	FaceDetectionAttribute
	EmotionAttribute
	FaceDetectionAnnotation
	VideoAnnotationResults
	AnnotateVideoResponse
	VideoAnnotationProgress
	AnnotateVideoProgress
	SpeechTranscriptionConfig
	SpeechContext
	SpeechTranscription
	SpeechRecognitionAlternative
	WordInfo
*/
package videointelligence

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf3 "github.com/golang/protobuf/ptypes/duration"
import google_protobuf4 "github.com/golang/protobuf/ptypes/timestamp"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Video annotation feature.
type Feature int32

const (
	// Unspecified.
	Feature_FEATURE_UNSPECIFIED Feature = 0
	// Label detection. Detect objects, such as dog or flower.
	Feature_LABEL_DETECTION Feature = 1
	// Shot change detection.
	Feature_SHOT_CHANGE_DETECTION Feature = 2
	// Explicit content detection.
	Feature_EXPLICIT_CONTENT_DETECTION Feature = 3
	// Face detection.
	Feature_FACE_DETECTION Feature = 8
	// Speech transcription.
	Feature_SPEECH_TRANSCRIPTION Feature = 6
)

var Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "LABEL_DETECTION",
	2: "SHOT_CHANGE_DETECTION",
	3: "EXPLICIT_CONTENT_DETECTION",
	8: "FACE_DETECTION",
	6: "SPEECH_TRANSCRIPTION",
}
var Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":        0,
	"LABEL_DETECTION":            1,
	"SHOT_CHANGE_DETECTION":      2,
	"EXPLICIT_CONTENT_DETECTION": 3,
	"FACE_DETECTION":             8,
	"SPEECH_TRANSCRIPTION":       6,
}

func (x Feature) String() string {
	return proto.EnumName(Feature_name, int32(x))
}
func (Feature) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Label detection mode.
type LabelDetectionMode int32

const (
	// Unspecified.
	LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED LabelDetectionMode = 0
	// Detect shot-level labels.
	LabelDetectionMode_SHOT_MODE LabelDetectionMode = 1
	// Detect frame-level labels.
	LabelDetectionMode_FRAME_MODE LabelDetectionMode = 2
	// Detect both shot-level and frame-level labels.
	LabelDetectionMode_SHOT_AND_FRAME_MODE LabelDetectionMode = 3
)

var LabelDetectionMode_name = map[int32]string{
	0: "LABEL_DETECTION_MODE_UNSPECIFIED",
	1: "SHOT_MODE",
	2: "FRAME_MODE",
	3: "SHOT_AND_FRAME_MODE",
}
var LabelDetectionMode_value = map[string]int32{
	"LABEL_DETECTION_MODE_UNSPECIFIED": 0,
	"SHOT_MODE":                        1,
	"FRAME_MODE":                       2,
	"SHOT_AND_FRAME_MODE":              3,
}

func (x LabelDetectionMode) String() string {
	return proto.EnumName(LabelDetectionMode_name, int32(x))
}
func (LabelDetectionMode) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Bucketized representation of likelihood.
type Likelihood int32

const (
	// Unspecified likelihood.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// Unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// Possible.
	Likelihood_POSSIBLE Likelihood = 3
	// Likely.
	Likelihood_LIKELY Likelihood = 4
	// Very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "LIKELIHOOD_UNSPECIFIED",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}
var Likelihood_value = map[string]int32{
	"LIKELIHOOD_UNSPECIFIED": 0,
	"VERY_UNLIKELY":          1,
	"UNLIKELY":               2,
	"POSSIBLE":               3,
	"LIKELY":                 4,
	"VERY_LIKELY":            5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}
func (Likelihood) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// Emotions.
type Emotion int32

const (
	// Unspecified emotion.
	Emotion_EMOTION_UNSPECIFIED Emotion = 0
	// Amusement.
	Emotion_AMUSEMENT Emotion = 1
	// Anger.
	Emotion_ANGER Emotion = 2
	// Concentration.
	Emotion_CONCENTRATION Emotion = 3
	// Contentment.
	Emotion_CONTENTMENT Emotion = 4
	// Desire.
	Emotion_DESIRE Emotion = 5
	// Disappointment.
	Emotion_DISAPPOINTMENT Emotion = 6
	// Disgust.
	Emotion_DISGUST Emotion = 7
	// Elation.
	Emotion_ELATION Emotion = 8
	// Embarrassment.
	Emotion_EMBARRASSMENT Emotion = 9
	// Interest.
	Emotion_INTEREST Emotion = 10
	// Pride.
	Emotion_PRIDE Emotion = 11
	// Sadness.
	Emotion_SADNESS Emotion = 12
	// Surprise.
	Emotion_SURPRISE Emotion = 13
)

var Emotion_name = map[int32]string{
	0:  "EMOTION_UNSPECIFIED",
	1:  "AMUSEMENT",
	2:  "ANGER",
	3:  "CONCENTRATION",
	4:  "CONTENTMENT",
	5:  "DESIRE",
	6:  "DISAPPOINTMENT",
	7:  "DISGUST",
	8:  "ELATION",
	9:  "EMBARRASSMENT",
	10: "INTEREST",
	11: "PRIDE",
	12: "SADNESS",
	13: "SURPRISE",
}
var Emotion_value = map[string]int32{
	"EMOTION_UNSPECIFIED": 0,
	"AMUSEMENT":           1,
	"ANGER":               2,
	"CONCENTRATION":       3,
	"CONTENTMENT":         4,
	"DESIRE":              5,
	"DISAPPOINTMENT":      6,
	"DISGUST":             7,
	"ELATION":             8,
	"EMBARRASSMENT":       9,
	"INTEREST":            10,
	"PRIDE":               11,
	"SADNESS":             12,
	"SURPRISE":            13,
}

func (x Emotion) String() string {
	return proto.EnumName(Emotion_name, int32(x))
}
func (Emotion) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

// Video annotation request.
type AnnotateVideoRequest struct {
	// Input video location. Currently, only
	// [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more information, see
	// [Request URIs](/storage/docs/reference-uris).
	// A video URI may include wildcards in `object-id`, and thus identify
	// multiple videos. Supported wildcards: '*' to match 0 or more characters;
	// '?' to match 1 character. If unset, the input video should be embedded
	// in the request as `input_content`. If set, `input_content` should be unset.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri" json:"input_uri,omitempty"`
	// The video data bytes.
	// If unset, the input video(s) should be specified via `input_uri`.
	// If set, `input_uri` should be unset.
	InputContent []byte `protobuf:"bytes,6,opt,name=input_content,json=inputContent,proto3" json:"input_content,omitempty"`
	// Requested video annotation features.
	Features []Feature `protobuf:"varint,2,rep,packed,name=features,enum=google.cloud.videointelligence.v1p1beta1.Feature" json:"features,omitempty"`
	// Additional video context and/or feature-specific parameters.
	VideoContext *VideoContext `protobuf:"bytes,3,opt,name=video_context,json=videoContext" json:"video_context,omitempty"`
	// Optional location where the output (in JSON format) should be stored.
	// Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
	// URIs are supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more information, see
	// [Request URIs](/storage/docs/reference-uris).
	OutputUri string `protobuf:"bytes,4,opt,name=output_uri,json=outputUri" json:"output_uri,omitempty"`
	// Optional cloud region where annotation should take place. Supported cloud
	// regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
	// is specified, a region will be determined based on video file location.
	LocationId string `protobuf:"bytes,5,opt,name=location_id,json=locationId" json:"location_id,omitempty"`
}

func (m *AnnotateVideoRequest) Reset()                    { *m = AnnotateVideoRequest{} }
func (m *AnnotateVideoRequest) String() string            { return proto.CompactTextString(m) }
func (*AnnotateVideoRequest) ProtoMessage()               {}
func (*AnnotateVideoRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *AnnotateVideoRequest) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetInputContent() []byte {
	if m != nil {
		return m.InputContent
	}
	return nil
}

func (m *AnnotateVideoRequest) GetFeatures() []Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateVideoRequest) GetVideoContext() *VideoContext {
	if m != nil {
		return m.VideoContext
	}
	return nil
}

func (m *AnnotateVideoRequest) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

// Video context and/or feature-specific parameters.
type VideoContext struct {
	// Video segments to annotate. The segments may overlap and are not required
	// to be contiguous or span the whole video. If unspecified, each video
	// is treated as a single segment.
	Segments []*VideoSegment `protobuf:"bytes,1,rep,name=segments" json:"segments,omitempty"`
	// Config for LABEL_DETECTION.
	LabelDetectionConfig *LabelDetectionConfig `protobuf:"bytes,2,opt,name=label_detection_config,json=labelDetectionConfig" json:"label_detection_config,omitempty"`
	// Config for SHOT_CHANGE_DETECTION.
	ShotChangeDetectionConfig *ShotChangeDetectionConfig `protobuf:"bytes,3,opt,name=shot_change_detection_config,json=shotChangeDetectionConfig" json:"shot_change_detection_config,omitempty"`
	// Config for EXPLICIT_CONTENT_DETECTION.
	ExplicitContentDetectionConfig *ExplicitContentDetectionConfig `protobuf:"bytes,4,opt,name=explicit_content_detection_config,json=explicitContentDetectionConfig" json:"explicit_content_detection_config,omitempty"`
	// Config for SPEECH_TRANSCRIPTION.
	SpeechTranscriptionConfig *SpeechTranscriptionConfig `protobuf:"bytes,6,opt,name=speech_transcription_config,json=speechTranscriptionConfig" json:"speech_transcription_config,omitempty"`
	// Config for FACE_DETECTION.
	FaceDetectionConfig *FaceConfig `protobuf:"bytes,7,opt,name=face_detection_config,json=faceDetectionConfig" json:"face_detection_config,omitempty"`
}

func (m *VideoContext) Reset()                    { *m = VideoContext{} }
func (m *VideoContext) String() string            { return proto.CompactTextString(m) }
func (*VideoContext) ProtoMessage()               {}
func (*VideoContext) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *VideoContext) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *VideoContext) GetLabelDetectionConfig() *LabelDetectionConfig {
	if m != nil {
		return m.LabelDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetShotChangeDetectionConfig() *ShotChangeDetectionConfig {
	if m != nil {
		return m.ShotChangeDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetExplicitContentDetectionConfig() *ExplicitContentDetectionConfig {
	if m != nil {
		return m.ExplicitContentDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetSpeechTranscriptionConfig() *SpeechTranscriptionConfig {
	if m != nil {
		return m.SpeechTranscriptionConfig
	}
	return nil
}

func (m *VideoContext) GetFaceDetectionConfig() *FaceConfig {
	if m != nil {
		return m.FaceDetectionConfig
	}
	return nil
}

// Config for LABEL_DETECTION.
type LabelDetectionConfig struct {
	// What labels should be detected with LABEL_DETECTION, in addition to
	// video-level labels or segment-level labels.
	// If unspecified, defaults to `SHOT_MODE`.
	LabelDetectionMode LabelDetectionMode `protobuf:"varint,1,opt,name=label_detection_mode,json=labelDetectionMode,enum=google.cloud.videointelligence.v1p1beta1.LabelDetectionMode" json:"label_detection_mode,omitempty"`
	// Whether the video has been shot from a stationary (i.e. non-moving) camera.
	// When set to true, might improve detection accuracy for moving objects.
	// Should be used with `SHOT_AND_FRAME_MODE` enabled.
	StationaryCamera bool `protobuf:"varint,2,opt,name=stationary_camera,json=stationaryCamera" json:"stationary_camera,omitempty"`
	// Model to use for label detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,3,opt,name=model" json:"model,omitempty"`
}

func (m *LabelDetectionConfig) Reset()                    { *m = LabelDetectionConfig{} }
func (m *LabelDetectionConfig) String() string            { return proto.CompactTextString(m) }
func (*LabelDetectionConfig) ProtoMessage()               {}
func (*LabelDetectionConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *LabelDetectionConfig) GetLabelDetectionMode() LabelDetectionMode {
	if m != nil {
		return m.LabelDetectionMode
	}
	return LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED
}

func (m *LabelDetectionConfig) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

func (m *LabelDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for SHOT_CHANGE_DETECTION.
type ShotChangeDetectionConfig struct {
	// Model to use for shot change detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model" json:"model,omitempty"`
}

func (m *ShotChangeDetectionConfig) Reset()                    { *m = ShotChangeDetectionConfig{} }
func (m *ShotChangeDetectionConfig) String() string            { return proto.CompactTextString(m) }
func (*ShotChangeDetectionConfig) ProtoMessage()               {}
func (*ShotChangeDetectionConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ShotChangeDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for EXPLICIT_CONTENT_DETECTION.
type ExplicitContentDetectionConfig struct {
	// Model to use for explicit content detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model" json:"model,omitempty"`
}

func (m *ExplicitContentDetectionConfig) Reset()                    { *m = ExplicitContentDetectionConfig{} }
func (m *ExplicitContentDetectionConfig) String() string            { return proto.CompactTextString(m) }
func (*ExplicitContentDetectionConfig) ProtoMessage()               {}
func (*ExplicitContentDetectionConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *ExplicitContentDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for FACE_DETECTION.
type FaceConfig struct {
	// Model to use for face detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model" json:"model,omitempty"`
	// Whether bounding boxes be included in the face annotation output.
	IncludeBoundingBoxes bool `protobuf:"varint,2,opt,name=include_bounding_boxes,json=includeBoundingBoxes" json:"include_bounding_boxes,omitempty"`
	// Whether to enable emotion detection. Ignored if 'include_bounding_boxes' is
	// false.
	IncludeEmotions bool `protobuf:"varint,4,opt,name=include_emotions,json=includeEmotions" json:"include_emotions,omitempty"`
}

func (m *FaceConfig) Reset()                    { *m = FaceConfig{} }
func (m *FaceConfig) String() string            { return proto.CompactTextString(m) }
func (*FaceConfig) ProtoMessage()               {}
func (*FaceConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *FaceConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *FaceConfig) GetIncludeBoundingBoxes() bool {
	if m != nil {
		return m.IncludeBoundingBoxes
	}
	return false
}

func (m *FaceConfig) GetIncludeEmotions() bool {
	if m != nil {
		return m.IncludeEmotions
	}
	return false
}

// Video segment.
type VideoSegment struct {
	// Time-offset, relative to the beginning of the video,
	// corresponding to the start of the segment (inclusive).
	StartTimeOffset *google_protobuf3.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset" json:"start_time_offset,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the end of the segment (inclusive).
	EndTimeOffset *google_protobuf3.Duration `protobuf:"bytes,2,opt,name=end_time_offset,json=endTimeOffset" json:"end_time_offset,omitempty"`
}

func (m *VideoSegment) Reset()                    { *m = VideoSegment{} }
func (m *VideoSegment) String() string            { return proto.CompactTextString(m) }
func (*VideoSegment) ProtoMessage()               {}
func (*VideoSegment) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *VideoSegment) GetStartTimeOffset() *google_protobuf3.Duration {
	if m != nil {
		return m.StartTimeOffset
	}
	return nil
}

func (m *VideoSegment) GetEndTimeOffset() *google_protobuf3.Duration {
	if m != nil {
		return m.EndTimeOffset
	}
	return nil
}

// Video segment level annotation results for label detection.
type LabelSegment struct {
	// Video segment where a label was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment" json:"segment,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence" json:"confidence,omitempty"`
}

func (m *LabelSegment) Reset()                    { *m = LabelSegment{} }
func (m *LabelSegment) String() string            { return proto.CompactTextString(m) }
func (*LabelSegment) ProtoMessage()               {}
func (*LabelSegment) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *LabelSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *LabelSegment) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Video frame level annotation results for label detection.
type LabelFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *google_protobuf3.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset" json:"time_offset,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence" json:"confidence,omitempty"`
}

func (m *LabelFrame) Reset()                    { *m = LabelFrame{} }
func (m *LabelFrame) String() string            { return proto.CompactTextString(m) }
func (*LabelFrame) ProtoMessage()               {}
func (*LabelFrame) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *LabelFrame) GetTimeOffset() *google_protobuf3.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *LabelFrame) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Detected entity from video analysis.
type Entity struct {
	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId" json:"entity_id,omitempty"`
	// Textual description, e.g. `Fixed-gear bicycle`.
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	// Language code for `description` in BCP-47 format.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode" json:"language_code,omitempty"`
}

func (m *Entity) Reset()                    { *m = Entity{} }
func (m *Entity) String() string            { return proto.CompactTextString(m) }
func (*Entity) ProtoMessage()               {}
func (*Entity) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *Entity) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func (m *Entity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Entity) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Label annotation.
type LabelAnnotation struct {
	// Detected entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity" json:"entity,omitempty"`
	// Common categories for the detected entity.
	// E.g. when the label is `Terrier` the category is likely `dog`. And in some
	// cases there might be more than one categories e.g. `Terrier` could also be
	// a `pet`.
	CategoryEntities []*Entity `protobuf:"bytes,2,rep,name=category_entities,json=categoryEntities" json:"category_entities,omitempty"`
	// All video segments where a label was detected.
	Segments []*LabelSegment `protobuf:"bytes,3,rep,name=segments" json:"segments,omitempty"`
	// All video frames where a label was detected.
	Frames []*LabelFrame `protobuf:"bytes,4,rep,name=frames" json:"frames,omitempty"`
}

func (m *LabelAnnotation) Reset()                    { *m = LabelAnnotation{} }
func (m *LabelAnnotation) String() string            { return proto.CompactTextString(m) }
func (*LabelAnnotation) ProtoMessage()               {}
func (*LabelAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *LabelAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *LabelAnnotation) GetCategoryEntities() []*Entity {
	if m != nil {
		return m.CategoryEntities
	}
	return nil
}

func (m *LabelAnnotation) GetSegments() []*LabelSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *LabelAnnotation) GetFrames() []*LabelFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Video frame level annotation results for explicit content.
type ExplicitContentFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *google_protobuf3.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset" json:"time_offset,omitempty"`
	// Likelihood of the pornography content..
	PornographyLikelihood Likelihood `protobuf:"varint,2,opt,name=pornography_likelihood,json=pornographyLikelihood,enum=google.cloud.videointelligence.v1p1beta1.Likelihood" json:"pornography_likelihood,omitempty"`
}

func (m *ExplicitContentFrame) Reset()                    { *m = ExplicitContentFrame{} }
func (m *ExplicitContentFrame) String() string            { return proto.CompactTextString(m) }
func (*ExplicitContentFrame) ProtoMessage()               {}
func (*ExplicitContentFrame) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *ExplicitContentFrame) GetTimeOffset() *google_protobuf3.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *ExplicitContentFrame) GetPornographyLikelihood() Likelihood {
	if m != nil {
		return m.PornographyLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

// Explicit content annotation (based on per-frame visual signals only).
// If no explicit content has been detected in a frame, no annotations are
// present for that frame.
type ExplicitContentAnnotation struct {
	// All video frames where explicit content was detected.
	Frames []*ExplicitContentFrame `protobuf:"bytes,1,rep,name=frames" json:"frames,omitempty"`
}

func (m *ExplicitContentAnnotation) Reset()                    { *m = ExplicitContentAnnotation{} }
func (m *ExplicitContentAnnotation) String() string            { return proto.CompactTextString(m) }
func (*ExplicitContentAnnotation) ProtoMessage()               {}
func (*ExplicitContentAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *ExplicitContentAnnotation) GetFrames() []*ExplicitContentFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Normalized bounding box.
// The normalized vertex coordinates are relative to the original image.
// Range: [0, 1].
type NormalizedBoundingBox struct {
	// Left X coordinate.
	Left float32 `protobuf:"fixed32,1,opt,name=left" json:"left,omitempty"`
	// Top Y coordinate.
	Top float32 `protobuf:"fixed32,2,opt,name=top" json:"top,omitempty"`
	// Right X coordinate.
	Right float32 `protobuf:"fixed32,3,opt,name=right" json:"right,omitempty"`
	// Bottom Y coordinate.
	Bottom float32 `protobuf:"fixed32,4,opt,name=bottom" json:"bottom,omitempty"`
}

func (m *NormalizedBoundingBox) Reset()                    { *m = NormalizedBoundingBox{} }
func (m *NormalizedBoundingBox) String() string            { return proto.CompactTextString(m) }
func (*NormalizedBoundingBox) ProtoMessage()               {}
func (*NormalizedBoundingBox) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *NormalizedBoundingBox) GetLeft() float32 {
	if m != nil {
		return m.Left
	}
	return 0
}

func (m *NormalizedBoundingBox) GetTop() float32 {
	if m != nil {
		return m.Top
	}
	return 0
}

func (m *NormalizedBoundingBox) GetRight() float32 {
	if m != nil {
		return m.Right
	}
	return 0
}

func (m *NormalizedBoundingBox) GetBottom() float32 {
	if m != nil {
		return m.Bottom
	}
	return 0
}

// Video segment level annotation results for face detection.
type FaceSegment struct {
	// Video segment where a face was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment" json:"segment,omitempty"`
}

func (m *FaceSegment) Reset()                    { *m = FaceSegment{} }
func (m *FaceSegment) String() string            { return proto.CompactTextString(m) }
func (*FaceSegment) ProtoMessage()               {}
func (*FaceSegment) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *FaceSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

// Video frame level annotation results for face detection.
type FaceDetectionFrame struct {
	// Face attributes in a frame.
	// There can be more than one attributes if the same face is detected in
	// multiple locations within the current frame.
	Attributes []*FaceDetectionAttribute `protobuf:"bytes,1,rep,name=attributes" json:"attributes,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the video frame for this location.
	TimeOffset *google_protobuf3.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset" json:"time_offset,omitempty"`
}

func (m *FaceDetectionFrame) Reset()                    { *m = FaceDetectionFrame{} }
func (m *FaceDetectionFrame) String() string            { return proto.CompactTextString(m) }
func (*FaceDetectionFrame) ProtoMessage()               {}
func (*FaceDetectionFrame) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *FaceDetectionFrame) GetAttributes() []*FaceDetectionAttribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *FaceDetectionFrame) GetTimeOffset() *google_protobuf3.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

// Face detection attribute.
type FaceDetectionAttribute struct {
	// Normalized Bounding box.
	NormalizedBoundingBox *NormalizedBoundingBox `protobuf:"bytes,1,opt,name=normalized_bounding_box,json=normalizedBoundingBox" json:"normalized_bounding_box,omitempty"`
	// Emotion attributes.
	Emotions []*EmotionAttribute `protobuf:"bytes,2,rep,name=emotions" json:"emotions,omitempty"`
}

func (m *FaceDetectionAttribute) Reset()                    { *m = FaceDetectionAttribute{} }
func (m *FaceDetectionAttribute) String() string            { return proto.CompactTextString(m) }
func (*FaceDetectionAttribute) ProtoMessage()               {}
func (*FaceDetectionAttribute) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *FaceDetectionAttribute) GetNormalizedBoundingBox() *NormalizedBoundingBox {
	if m != nil {
		return m.NormalizedBoundingBox
	}
	return nil
}

func (m *FaceDetectionAttribute) GetEmotions() []*EmotionAttribute {
	if m != nil {
		return m.Emotions
	}
	return nil
}

// Emotion attribute.
type EmotionAttribute struct {
	// Emotion entry.
	Emotion Emotion `protobuf:"varint,1,opt,name=emotion,enum=google.cloud.videointelligence.v1p1beta1.Emotion" json:"emotion,omitempty"`
	// Confidence score.
	Score float32 `protobuf:"fixed32,2,opt,name=score" json:"score,omitempty"`
}

func (m *EmotionAttribute) Reset()                    { *m = EmotionAttribute{} }
func (m *EmotionAttribute) String() string            { return proto.CompactTextString(m) }
func (*EmotionAttribute) ProtoMessage()               {}
func (*EmotionAttribute) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *EmotionAttribute) GetEmotion() Emotion {
	if m != nil {
		return m.Emotion
	}
	return Emotion_EMOTION_UNSPECIFIED
}

func (m *EmotionAttribute) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

// Face detection annotation.
type FaceDetectionAnnotation struct {
	// All video segments where a face was detected.
	Segments []*FaceSegment `protobuf:"bytes,1,rep,name=segments" json:"segments,omitempty"`
	// All video frames where a face was detected.
	Frames []*FaceDetectionFrame `protobuf:"bytes,2,rep,name=frames" json:"frames,omitempty"`
}

func (m *FaceDetectionAnnotation) Reset()                    { *m = FaceDetectionAnnotation{} }
func (m *FaceDetectionAnnotation) String() string            { return proto.CompactTextString(m) }
func (*FaceDetectionAnnotation) ProtoMessage()               {}
func (*FaceDetectionAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *FaceDetectionAnnotation) GetSegments() []*FaceSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *FaceDetectionAnnotation) GetFrames() []*FaceDetectionFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Annotation results for a single video.
type VideoAnnotationResults struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri" json:"input_uri,omitempty"`
	// Label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label.
	SegmentLabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=segment_label_annotations,json=segmentLabelAnnotations" json:"segment_label_annotations,omitempty"`
	// Label annotations on shot level.
	// There is exactly one element for each unique label.
	ShotLabelAnnotations []*LabelAnnotation `protobuf:"bytes,3,rep,name=shot_label_annotations,json=shotLabelAnnotations" json:"shot_label_annotations,omitempty"`
	// Label annotations on frame level.
	// There is exactly one element for each unique label.
	FrameLabelAnnotations []*LabelAnnotation `protobuf:"bytes,4,rep,name=frame_label_annotations,json=frameLabelAnnotations" json:"frame_label_annotations,omitempty"`
	// Face detection annotations.
	FaceDetectionAnnotations []*FaceDetectionAnnotation `protobuf:"bytes,13,rep,name=face_detection_annotations,json=faceDetectionAnnotations" json:"face_detection_annotations,omitempty"`
	// Shot annotations. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,6,rep,name=shot_annotations,json=shotAnnotations" json:"shot_annotations,omitempty"`
	// Explicit content annotation.
	ExplicitAnnotation *ExplicitContentAnnotation `protobuf:"bytes,7,opt,name=explicit_annotation,json=explicitAnnotation" json:"explicit_annotation,omitempty"`
	// Speech transcription.
	SpeechTranscriptions []*SpeechTranscription `protobuf:"bytes,11,rep,name=speech_transcriptions,json=speechTranscriptions" json:"speech_transcriptions,omitempty"`
	// If set, indicates an error. Note that for a single `AnnotateVideoRequest`
	// some videos may succeed and some may fail.
	Error *google_rpc.Status `protobuf:"bytes,9,opt,name=error" json:"error,omitempty"`
}

func (m *VideoAnnotationResults) Reset()                    { *m = VideoAnnotationResults{} }
func (m *VideoAnnotationResults) String() string            { return proto.CompactTextString(m) }
func (*VideoAnnotationResults) ProtoMessage()               {}
func (*VideoAnnotationResults) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *VideoAnnotationResults) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationResults) GetSegmentLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.SegmentLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.ShotLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFrameLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.FrameLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFaceDetectionAnnotations() []*FaceDetectionAnnotation {
	if m != nil {
		return m.FaceDetectionAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetExplicitAnnotation() *ExplicitContentAnnotation {
	if m != nil {
		return m.ExplicitAnnotation
	}
	return nil
}

func (m *VideoAnnotationResults) GetSpeechTranscriptions() []*SpeechTranscription {
	if m != nil {
		return m.SpeechTranscriptions
	}
	return nil
}

func (m *VideoAnnotationResults) GetError() *google_rpc.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Video annotation response. Included in the `response`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoResponse struct {
	// Annotation results for all videos specified in `AnnotateVideoRequest`.
	AnnotationResults []*VideoAnnotationResults `protobuf:"bytes,1,rep,name=annotation_results,json=annotationResults" json:"annotation_results,omitempty"`
}

func (m *AnnotateVideoResponse) Reset()                    { *m = AnnotateVideoResponse{} }
func (m *AnnotateVideoResponse) String() string            { return proto.CompactTextString(m) }
func (*AnnotateVideoResponse) ProtoMessage()               {}
func (*AnnotateVideoResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *AnnotateVideoResponse) GetAnnotationResults() []*VideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

// Annotation progress for a single video.
type VideoAnnotationProgress struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri" json:"input_uri,omitempty"`
	// Approximate percentage processed thus far.
	// Guaranteed to be 100 when fully processed.
	ProgressPercent int32 `protobuf:"varint,2,opt,name=progress_percent,json=progressPercent" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *google_protobuf4.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// Time of the most recent update.
	UpdateTime *google_protobuf4.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime" json:"update_time,omitempty"`
}

func (m *VideoAnnotationProgress) Reset()                    { *m = VideoAnnotationProgress{} }
func (m *VideoAnnotationProgress) String() string            { return proto.CompactTextString(m) }
func (*VideoAnnotationProgress) ProtoMessage()               {}
func (*VideoAnnotationProgress) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *VideoAnnotationProgress) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationProgress) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *VideoAnnotationProgress) GetStartTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetUpdateTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// Video annotation progress. Included in the `metadata`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoProgress struct {
	// Progress metadata for all videos specified in `AnnotateVideoRequest`.
	AnnotationProgress []*VideoAnnotationProgress `protobuf:"bytes,1,rep,name=annotation_progress,json=annotationProgress" json:"annotation_progress,omitempty"`
}

func (m *AnnotateVideoProgress) Reset()                    { *m = AnnotateVideoProgress{} }
func (m *AnnotateVideoProgress) String() string            { return proto.CompactTextString(m) }
func (*AnnotateVideoProgress) ProtoMessage()               {}
func (*AnnotateVideoProgress) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *AnnotateVideoProgress) GetAnnotationProgress() []*VideoAnnotationProgress {
	if m != nil {
		return m.AnnotationProgress
	}
	return nil
}

// Config for SPEECH_TRANSCRIPTION.
type SpeechTranscriptionConfig struct {
	// *Required* The language of the supplied audio as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
	// Example: "en-US".
	// See [Language Support](https://cloud.google.com/speech/docs/languages)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode" json:"language_code,omitempty"`
	// *Optional* Maximum number of recognition hypotheses to be returned.
	// Specifically, the maximum number of `SpeechRecognitionAlternative` messages
	// within each `SpeechRecognitionResult`. The server may return fewer than
	// `max_alternatives`. Valid values are `0`-`30`. A value of `0` or `1` will
	// return a maximum of one. If omitted, will return a maximum of one.
	MaxAlternatives int32 `protobuf:"varint,2,opt,name=max_alternatives,json=maxAlternatives" json:"max_alternatives,omitempty"`
	// *Optional* If set to `true`, the server will attempt to filter out
	// profanities, replacing all but the initial character in each filtered word
	// with asterisks, e.g. "f***". If set to `false` or omitted, profanities
	// won't be filtered out.
	FilterProfanity bool `protobuf:"varint,3,opt,name=filter_profanity,json=filterProfanity" json:"filter_profanity,omitempty"`
	// *Optional* A means to provide context to assist the speech recognition.
	SpeechContexts []*SpeechContext `protobuf:"bytes,4,rep,name=speech_contexts,json=speechContexts" json:"speech_contexts,omitempty"`
	// *Optional* For file formats, such as MXF or MKV, supporting multiple audio
	// tracks, specify up to two tracks. Default: track 0.
	AudioTracks []int32 `protobuf:"varint,6,rep,packed,name=audio_tracks,json=audioTracks" json:"audio_tracks,omitempty"`
}

func (m *SpeechTranscriptionConfig) Reset()                    { *m = SpeechTranscriptionConfig{} }
func (m *SpeechTranscriptionConfig) String() string            { return proto.CompactTextString(m) }
func (*SpeechTranscriptionConfig) ProtoMessage()               {}
func (*SpeechTranscriptionConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *SpeechTranscriptionConfig) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *SpeechTranscriptionConfig) GetMaxAlternatives() int32 {
	if m != nil {
		return m.MaxAlternatives
	}
	return 0
}

func (m *SpeechTranscriptionConfig) GetFilterProfanity() bool {
	if m != nil {
		return m.FilterProfanity
	}
	return false
}

func (m *SpeechTranscriptionConfig) GetSpeechContexts() []*SpeechContext {
	if m != nil {
		return m.SpeechContexts
	}
	return nil
}

func (m *SpeechTranscriptionConfig) GetAudioTracks() []int32 {
	if m != nil {
		return m.AudioTracks
	}
	return nil
}

// Provides "hints" to the speech recognizer to favor specific words and phrases
// in the results.
type SpeechContext struct {
	// *Optional* A list of strings containing words and phrases "hints" so that
	// the speech recognition is more likely to recognize them. This can be used
	// to improve the accuracy for specific words and phrases, for example, if
	// specific commands are typically spoken by the user. This can also be used
	// to add additional words to the vocabulary of the recognizer. See
	// [usage limits](https://cloud.google.com/speech/limits#content).
	Phrases []string `protobuf:"bytes,1,rep,name=phrases" json:"phrases,omitempty"`
}

func (m *SpeechContext) Reset()                    { *m = SpeechContext{} }
func (m *SpeechContext) String() string            { return proto.CompactTextString(m) }
func (*SpeechContext) ProtoMessage()               {}
func (*SpeechContext) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *SpeechContext) GetPhrases() []string {
	if m != nil {
		return m.Phrases
	}
	return nil
}

// A speech recognition result corresponding to a portion of the audio.
type SpeechTranscription struct {
	// Output only. May contain one or more recognition hypotheses (up to the
	// maximum specified in `max_alternatives`).
	// These alternatives are ordered in terms of accuracy, with the top (first)
	// alternative being the most probable, as ranked by the recognizer.
	Alternatives []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives" json:"alternatives,omitempty"`
}

func (m *SpeechTranscription) Reset()                    { *m = SpeechTranscription{} }
func (m *SpeechTranscription) String() string            { return proto.CompactTextString(m) }
func (*SpeechTranscription) ProtoMessage()               {}
func (*SpeechTranscription) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *SpeechTranscription) GetAlternatives() []*SpeechRecognitionAlternative {
	if m != nil {
		return m.Alternatives
	}
	return nil
}

// Alternative hypotheses (a.k.a. n-best list).
type SpeechRecognitionAlternative struct {
	// Output only. Transcript text representing the words that the user spoke.
	Transcript string `protobuf:"bytes,1,opt,name=transcript" json:"transcript,omitempty"`
	// Output only. The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is typically provided only for the top hypothesis, and
	// only for `is_final=true` results. Clients should not rely on the
	// `confidence` field as it is not guaranteed to be accurate or consistent.
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence" json:"confidence,omitempty"`
	// Output only. A list of word-specific information for each recognized word.
	Words []*WordInfo `protobuf:"bytes,3,rep,name=words" json:"words,omitempty"`
}

func (m *SpeechRecognitionAlternative) Reset()                    { *m = SpeechRecognitionAlternative{} }
func (m *SpeechRecognitionAlternative) String() string            { return proto.CompactTextString(m) }
func (*SpeechRecognitionAlternative) ProtoMessage()               {}
func (*SpeechRecognitionAlternative) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *SpeechRecognitionAlternative) GetTranscript() string {
	if m != nil {
		return m.Transcript
	}
	return ""
}

func (m *SpeechRecognitionAlternative) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *SpeechRecognitionAlternative) GetWords() []*WordInfo {
	if m != nil {
		return m.Words
	}
	return nil
}

// Word-specific information for recognized words. Word information is only
// included in the response when certain request parameters are set, such
// as `enable_word_time_offsets`.
type WordInfo struct {
	// Output only. Time offset relative to the beginning of the audio, and
	// corresponding to the start of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	StartTime *google_protobuf3.Duration `protobuf:"bytes,1,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// Output only. Time offset relative to the beginning of the audio, and
	// corresponding to the end of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	EndTime *google_protobuf3.Duration `protobuf:"bytes,2,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
	// Output only. The word corresponding to this set of information.
	Word string `protobuf:"bytes,3,opt,name=word" json:"word,omitempty"`
}

func (m *WordInfo) Reset()                    { *m = WordInfo{} }
func (m *WordInfo) String() string            { return proto.CompactTextString(m) }
func (*WordInfo) ProtoMessage()               {}
func (*WordInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *WordInfo) GetStartTime() *google_protobuf3.Duration {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *WordInfo) GetEndTime() *google_protobuf3.Duration {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *WordInfo) GetWord() string {
	if m != nil {
		return m.Word
	}
	return ""
}

func init() {
	proto.RegisterType((*AnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest")
	proto.RegisterType((*VideoContext)(nil), "google.cloud.videointelligence.v1p1beta1.VideoContext")
	proto.RegisterType((*LabelDetectionConfig)(nil), "google.cloud.videointelligence.v1p1beta1.LabelDetectionConfig")
	proto.RegisterType((*ShotChangeDetectionConfig)(nil), "google.cloud.videointelligence.v1p1beta1.ShotChangeDetectionConfig")
	proto.RegisterType((*ExplicitContentDetectionConfig)(nil), "google.cloud.videointelligence.v1p1beta1.ExplicitContentDetectionConfig")
	proto.RegisterType((*FaceConfig)(nil), "google.cloud.videointelligence.v1p1beta1.FaceConfig")
	proto.RegisterType((*VideoSegment)(nil), "google.cloud.videointelligence.v1p1beta1.VideoSegment")
	proto.RegisterType((*LabelSegment)(nil), "google.cloud.videointelligence.v1p1beta1.LabelSegment")
	proto.RegisterType((*LabelFrame)(nil), "google.cloud.videointelligence.v1p1beta1.LabelFrame")
	proto.RegisterType((*Entity)(nil), "google.cloud.videointelligence.v1p1beta1.Entity")
	proto.RegisterType((*LabelAnnotation)(nil), "google.cloud.videointelligence.v1p1beta1.LabelAnnotation")
	proto.RegisterType((*ExplicitContentFrame)(nil), "google.cloud.videointelligence.v1p1beta1.ExplicitContentFrame")
	proto.RegisterType((*ExplicitContentAnnotation)(nil), "google.cloud.videointelligence.v1p1beta1.ExplicitContentAnnotation")
	proto.RegisterType((*NormalizedBoundingBox)(nil), "google.cloud.videointelligence.v1p1beta1.NormalizedBoundingBox")
	proto.RegisterType((*FaceSegment)(nil), "google.cloud.videointelligence.v1p1beta1.FaceSegment")
	proto.RegisterType((*FaceDetectionFrame)(nil), "google.cloud.videointelligence.v1p1beta1.FaceDetectionFrame")
	proto.RegisterType((*FaceDetectionAttribute)(nil), "google.cloud.videointelligence.v1p1beta1.FaceDetectionAttribute")
	proto.RegisterType((*EmotionAttribute)(nil), "google.cloud.videointelligence.v1p1beta1.EmotionAttribute")
	proto.RegisterType((*FaceDetectionAnnotation)(nil), "google.cloud.videointelligence.v1p1beta1.FaceDetectionAnnotation")
	proto.RegisterType((*VideoAnnotationResults)(nil), "google.cloud.videointelligence.v1p1beta1.VideoAnnotationResults")
	proto.RegisterType((*AnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1p1beta1.AnnotateVideoResponse")
	proto.RegisterType((*VideoAnnotationProgress)(nil), "google.cloud.videointelligence.v1p1beta1.VideoAnnotationProgress")
	proto.RegisterType((*AnnotateVideoProgress)(nil), "google.cloud.videointelligence.v1p1beta1.AnnotateVideoProgress")
	proto.RegisterType((*SpeechTranscriptionConfig)(nil), "google.cloud.videointelligence.v1p1beta1.SpeechTranscriptionConfig")
	proto.RegisterType((*SpeechContext)(nil), "google.cloud.videointelligence.v1p1beta1.SpeechContext")
	proto.RegisterType((*SpeechTranscription)(nil), "google.cloud.videointelligence.v1p1beta1.SpeechTranscription")
	proto.RegisterType((*SpeechRecognitionAlternative)(nil), "google.cloud.videointelligence.v1p1beta1.SpeechRecognitionAlternative")
	proto.RegisterType((*WordInfo)(nil), "google.cloud.videointelligence.v1p1beta1.WordInfo")
	proto.RegisterEnum("google.cloud.videointelligence.v1p1beta1.Feature", Feature_name, Feature_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p1beta1.LabelDetectionMode", LabelDetectionMode_name, LabelDetectionMode_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p1beta1.Likelihood", Likelihood_name, Likelihood_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p1beta1.Emotion", Emotion_name, Emotion_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for VideoIntelligenceService service

type VideoIntelligenceServiceClient interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
}

type videoIntelligenceServiceClient struct {
	cc *grpc.ClientConn
}

func NewVideoIntelligenceServiceClient(cc *grpc.ClientConn) VideoIntelligenceServiceClient {
	return &videoIntelligenceServiceClient{cc}
}

func (c *videoIntelligenceServiceClient) AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.videointelligence.v1p1beta1.VideoIntelligenceService/AnnotateVideo", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for VideoIntelligenceService service

type VideoIntelligenceServiceServer interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(context.Context, *AnnotateVideoRequest) (*google_longrunning.Operation, error)
}

func RegisterVideoIntelligenceServiceServer(s *grpc.Server, srv VideoIntelligenceServiceServer) {
	s.RegisterService(&_VideoIntelligenceService_serviceDesc, srv)
}

func _VideoIntelligenceService_AnnotateVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.videointelligence.v1p1beta1.VideoIntelligenceService/AnnotateVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, req.(*AnnotateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1p1beta1.VideoIntelligenceService",
	HandlerType: (*VideoIntelligenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnnotateVideo",
			Handler:    _VideoIntelligenceService_AnnotateVideo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/videointelligence/v1p1beta1/video_intelligence.proto",
}

func init() {
	proto.RegisterFile("google/cloud/videointelligence/v1p1beta1/video_intelligence.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 2237 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x59, 0x4b, 0x6f, 0x23, 0x59,
	0xf5, 0xff, 0x97, 0x1d, 0x3b, 0xf1, 0x71, 0x12, 0xbb, 0x6f, 0x5e, 0x4e, 0xa6, 0x1f, 0x99, 0x9a,
	0x3f, 0x52, 0xba, 0x41, 0x0e, 0x09, 0xcd, 0xc0, 0xf4, 0x0c, 0x03, 0x15, 0xbb, 0xd2, 0xb1, 0x26,
	0xb1, 0xcd, 0x2d, 0x27, 0xd0, 0xd0, 0xa8, 0xa6, 0x52, 0x75, 0xed, 0x14, 0x5d, 0xae, 0xeb, 0xa9,
	0x2a, 0xf7, 0x74, 0xb3, 0x61, 0x60, 0x58, 0x8c, 0x84, 0xc4, 0x66, 0x84, 0x84, 0xc4, 0x86, 0x25,
	0x62, 0x39, 0x5f, 0x00, 0x09, 0xb1, 0x81, 0x2d, 0x2b, 0x24, 0x36, 0x48, 0xb0, 0xe0, 0x5b, 0xa0,
	0xfb, 0x28, 0xbb, 0xfc, 0x48, 0x27, 0x4e, 0x8b, 0x9d, 0xef, 0x39, 0xf7, 0xfe, 0xce, 0xe3, 0x9e,
	0x47, 0x9d, 0x6b, 0xd0, 0x3a, 0x94, 0x76, 0x3c, 0xb2, 0x6b, 0x7b, 0xb4, 0xef, 0xec, 0x3e, 0x77,
	0x1d, 0x42, 0x5d, 0x3f, 0x22, 0x9e, 0xe7, 0x76, 0x88, 0x6f, 0x93, 0xdd, 0xe7, 0x7b, 0xbd, 0xbd,
	0x73, 0x12, 0x59, 0x7b, 0x82, 0x67, 0x26, 0x99, 0xe5, 0x5e, 0x40, 0x23, 0x8a, 0x76, 0x04, 0x44,
	0x99, 0x43, 0x94, 0x27, 0x20, 0xca, 0x03, 0x88, 0xad, 0xdb, 0x52, 0x98, 0xd5, 0x73, 0x77, 0x2d,
	0xdf, 0xa7, 0x91, 0x15, 0xb9, 0xd4, 0x0f, 0x05, 0xce, 0xd6, 0x5b, 0x92, 0xeb, 0x51, 0xbf, 0x13,
	0xf4, 0x7d, 0xdf, 0xf5, 0x3b, 0xbb, 0xb4, 0x47, 0x82, 0x91, 0x4d, 0x77, 0xe5, 0x26, 0xbe, 0x3a,
	0xef, 0xb7, 0x77, 0x9d, 0xbe, 0xd8, 0x20, 0xf9, 0xf7, 0xc6, 0xf9, 0x91, 0xdb, 0x25, 0x61, 0x64,
	0x75, 0x7b, 0x72, 0xc3, 0x86, 0xdc, 0x10, 0xf4, 0xec, 0xdd, 0x30, 0xb2, 0xa2, 0xbe, 0x44, 0x56,
	0xff, 0x9c, 0x82, 0x55, 0x4d, 0x28, 0x45, 0xce, 0x98, 0x11, 0x98, 0x7c, 0xd4, 0x27, 0x61, 0x84,
	0xde, 0x80, 0x9c, 0xeb, 0xf7, 0xfa, 0x91, 0xd9, 0x0f, 0xdc, 0x92, 0xb2, 0xad, 0xec, 0xe4, 0xf0,
	0x02, 0x27, 0x9c, 0x06, 0x2e, 0x7a, 0x0b, 0x96, 0x04, 0xd3, 0xa6, 0x7e, 0x44, 0xfc, 0xa8, 0x94,
	0xdd, 0x56, 0x76, 0x16, 0xf1, 0x22, 0x27, 0x56, 0x04, 0x0d, 0x9d, 0xc0, 0x42, 0x9b, 0x58, 0x51,
	0x3f, 0x20, 0x61, 0x29, 0xb5, 0x9d, 0xde, 0x59, 0xde, 0xdf, 0x2b, 0x5f, 0xd7, 0x69, 0xe5, 0x43,
	0x71, 0x12, 0x0f, 0x20, 0xd0, 0x0f, 0x61, 0x49, 0x5c, 0x06, 0x97, 0xf9, 0x22, 0x2a, 0xa5, 0xb7,
	0x95, 0x9d, 0xfc, 0xfe, 0xdb, 0xd7, 0xc7, 0xe4, 0xf6, 0x55, 0xc4, 0x69, 0xbc, 0xf8, 0x3c, 0xb1,
	0x42, 0x77, 0x00, 0x68, 0x3f, 0x8a, 0xcd, 0x9d, 0xe3, 0xe6, 0xe6, 0x04, 0x85, 0xd9, 0x7b, 0x0f,
	0xf2, 0x1e, 0xb5, 0xb9, 0xc7, 0x4d, 0xd7, 0x29, 0x65, 0x38, 0x1f, 0x62, 0x52, 0xcd, 0x51, 0xff,
	0x9d, 0x81, 0xc5, 0x24, 0x3c, 0xc2, 0xb0, 0x10, 0x92, 0x4e, 0x97, 0xf8, 0x51, 0x58, 0x52, 0xb6,
	0xd3, 0x37, 0x50, 0xd4, 0x10, 0xc7, 0xf1, 0x00, 0x07, 0x45, 0xb0, 0xee, 0x59, 0xe7, 0xc4, 0x33,
	0x1d, 0x12, 0x11, 0x9b, 0x2b, 0x63, 0x53, 0xbf, 0xed, 0x76, 0x4a, 0x29, 0xee, 0x8a, 0xf7, 0xaf,
	0x2f, 0xe1, 0x98, 0xe1, 0x54, 0x63, 0x98, 0x0a, 0x47, 0xc1, 0xab, 0xde, 0x14, 0x2a, 0xfa, 0x85,
	0x02, 0xb7, 0xc3, 0x0b, 0x1a, 0x99, 0xf6, 0x85, 0xe5, 0x77, 0xc8, 0xa4, 0x70, 0x71, 0x0f, 0x95,
	0xeb, 0x0b, 0x37, 0x2e, 0x68, 0x54, 0xe1, 0x60, 0xe3, 0x1a, 0x6c, 0x86, 0x97, 0xb1, 0xd0, 0xe7,
	0x0a, 0xbc, 0x49, 0x5e, 0xf4, 0x3c, 0xd7, 0x76, 0x07, 0x61, 0x37, 0xa9, 0xcb, 0x1c, 0xd7, 0xe5,
	0xe8, 0xfa, 0xba, 0xe8, 0x12, 0x52, 0x06, 0xed, 0xb8, 0x42, 0x77, 0xc9, 0x2b, 0xf9, 0xe8, 0x53,
	0x05, 0xde, 0x08, 0x7b, 0x84, 0xd8, 0x17, 0x66, 0x14, 0x58, 0x7e, 0x68, 0x07, 0x6e, 0x2f, 0xa9,
	0x4f, 0x76, 0x66, 0xdf, 0x70, 0xb0, 0x56, 0x12, 0x6b, 0xe0, 0x9b, 0xcb, 0x58, 0xe8, 0x02, 0xd6,
	0xda, 0x96, 0x3d, 0xe5, 0x6a, 0xe6, 0xb9, 0xf8, 0x87, 0x33, 0xa4, 0x9d, 0x65, 0x13, 0x29, 0x6f,
	0x85, 0x41, 0x8e, 0xd9, 0xab, 0xfe, 0x45, 0x81, 0xd5, 0x69, 0xb1, 0x83, 0x7c, 0x58, 0x1d, 0x8f,
	0xcd, 0x2e, 0x75, 0x08, 0xaf, 0x1c, 0xcb, 0xfb, 0xef, 0xdd, 0x34, 0x32, 0x4f, 0xa8, 0x43, 0x30,
	0xf2, 0x26, 0x68, 0xe8, 0xcb, 0x70, 0x2b, 0x14, 0x85, 0xd4, 0x0a, 0x5e, 0x9a, 0xb6, 0xd5, 0x25,
	0x81, 0xc5, 0xd3, 0x60, 0x01, 0x17, 0x87, 0x8c, 0x0a, 0xa7, 0xa3, 0x55, 0xc8, 0x30, 0x65, 0x3c,
	0x1e, 0xaa, 0x39, 0x2c, 0x16, 0xea, 0x1e, 0x6c, 0x5e, 0x1a, 0x89, 0xc3, 0x23, 0x4a, 0xf2, 0xc8,
	0xdb, 0x70, 0xf7, 0xd5, 0x01, 0x73, 0xc9, 0xb9, 0x4f, 0x15, 0x80, 0xa1, 0x6b, 0xa7, 0x6f, 0x42,
	0x0f, 0x61, 0xdd, 0xf5, 0x6d, 0xaf, 0xef, 0x10, 0xf3, 0x9c, 0xf6, 0x7d, 0xc7, 0xf5, 0x3b, 0xe6,
	0x39, 0x7d, 0xc1, 0xab, 0x27, 0xb3, 0x6b, 0x55, 0x72, 0x0f, 0x24, 0xf3, 0x80, 0xf1, 0xd0, 0x7d,
	0x28, 0xc6, 0xa7, 0x48, 0x97, 0xf2, 0xa6, 0xc1, 0xb3, 0x60, 0x01, 0x17, 0x24, 0x5d, 0x97, 0x64,
	0xf5, 0x37, 0x8a, 0x2c, 0x52, 0xb2, 0xb4, 0x20, 0x9d, 0x3b, 0x31, 0x88, 0x4c, 0xd6, 0x2e, 0x4c,
	0xda, 0x6e, 0x87, 0x24, 0xe2, 0x3a, 0xe5, 0xf7, 0x37, 0xe3, 0x1b, 0x8b, 0x5b, 0x4a, 0xb9, 0x2a,
	0x5b, 0x0e, 0x2e, 0xf0, 0x33, 0x2d, 0xb7, 0x4b, 0x1a, 0xfc, 0x04, 0xd2, 0xa0, 0x40, 0x7c, 0x67,
	0x04, 0x24, 0x75, 0x15, 0xc8, 0x12, 0xf1, 0x9d, 0x21, 0x84, 0xfa, 0x89, 0x02, 0x8b, 0xfc, 0xe6,
	0x63, 0xd5, 0x9a, 0x30, 0x2f, 0xeb, 0x9e, 0x54, 0xe8, 0xa6, 0xe5, 0x33, 0x86, 0x41, 0x77, 0x01,
	0x78, 0x56, 0x38, 0x6c, 0x37, 0x57, 0x30, 0x85, 0x13, 0x14, 0xf5, 0x02, 0x80, 0x6b, 0x70, 0x18,
	0x58, 0x5d, 0x82, 0x1e, 0x41, 0x7e, 0x26, 0xa7, 0x40, 0x34, 0xf4, 0xc7, 0x55, 0x92, 0x3c, 0xc8,
	0xea, 0x7e, 0xe4, 0x46, 0x2f, 0x59, 0x93, 0x25, 0xfc, 0x17, 0xeb, 0x2a, 0xb2, 0xc9, 0x0a, 0x42,
	0xcd, 0x41, 0xdb, 0x90, 0x77, 0xc8, 0x20, 0xd5, 0x39, 0x4e, 0x0e, 0x27, 0x49, 0xac, 0x0d, 0x7b,
	0x96, 0xdf, 0xe9, 0x5b, 0x1d, 0x62, 0xda, 0x2c, 0xdb, 0x44, 0x7c, 0x2f, 0xc6, 0xc4, 0x0a, 0x75,
	0x88, 0xfa, 0x8f, 0x14, 0x14, 0xb8, 0x61, 0xda, 0xe0, 0xdb, 0x03, 0x1d, 0x41, 0x56, 0x88, 0x91,
	0x86, 0x7d, 0x75, 0x86, 0x82, 0xc9, 0xcf, 0x61, 0x79, 0x1e, 0xfd, 0x08, 0x6e, 0xd9, 0x56, 0x44,
	0x3a, 0x34, 0x78, 0x69, 0x72, 0x92, 0x2b, 0xbb, 0xfd, 0x4d, 0x40, 0x8b, 0x31, 0x94, 0x2e, 0x91,
	0x46, 0xda, 0x68, 0x7a, 0xd6, 0x36, 0x9a, 0x0c, 0xa8, 0x44, 0x1b, 0x3d, 0x86, 0x6c, 0x9b, 0xdd,
	0x31, 0xcb, 0x93, 0xf4, 0x6c, 0xe5, 0x71, 0x18, 0x20, 0x58, 0x62, 0xa8, 0x7f, 0x54, 0x60, 0x75,
	0xac, 0x26, 0xbc, 0x7e, 0x04, 0x3d, 0x83, 0xf5, 0x1e, 0x0d, 0x7c, 0xda, 0x09, 0xac, 0xde, 0xc5,
	0x4b, 0xd3, 0x73, 0x9f, 0x11, 0xcf, 0xbd, 0xa0, 0xd4, 0xe1, 0x51, 0xb0, 0x3c, 0x93, 0xca, 0x83,
	0xb3, 0x78, 0x2d, 0x81, 0x39, 0x24, 0xab, 0x21, 0x6c, 0x8e, 0x19, 0x90, 0x88, 0x94, 0xb3, 0x81,
	0xb3, 0xc4, 0x57, 0xcc, 0xfb, 0x37, 0x6e, 0xad, 0xa3, 0x6e, 0x7b, 0x06, 0x6b, 0x75, 0x1a, 0x74,
	0x2d, 0xcf, 0xfd, 0x09, 0x71, 0x12, 0x15, 0x0d, 0x21, 0x98, 0xf3, 0x48, 0x5b, 0xf8, 0x2b, 0x85,
	0xf9, 0x6f, 0x54, 0x84, 0x74, 0x44, 0x7b, 0x32, 0x93, 0xd8, 0x4f, 0x56, 0x41, 0x03, 0xb7, 0x73,
	0x21, 0x3e, 0x02, 0x53, 0x58, 0x2c, 0xd0, 0x3a, 0x64, 0xcf, 0x69, 0x14, 0xd1, 0x2e, 0xaf, 0x80,
	0x29, 0x2c, 0x57, 0xaa, 0x09, 0x79, 0x56, 0x7d, 0xff, 0x67, 0xb5, 0x45, 0xfd, 0x42, 0x01, 0x74,
	0x98, 0x6c, 0x97, 0x22, 0x04, 0x3e, 0x04, 0xb0, 0xa2, 0x28, 0x70, 0xcf, 0xfb, 0xd1, 0xc0, 0x81,
	0xdf, 0x99, 0xad, 0x19, 0x0f, 0x10, 0xb5, 0x18, 0x08, 0x27, 0x30, 0xc7, 0x83, 0x2c, 0x35, 0x43,
	0x90, 0xa9, 0xff, 0x51, 0x60, 0x7d, 0xba, 0x08, 0xf4, 0x31, 0x6c, 0xf8, 0x83, 0xdb, 0x19, 0xe9,
	0x46, 0xd2, 0x63, 0xdf, 0xbe, 0xbe, 0x15, 0x53, 0xaf, 0x19, 0xaf, 0xf9, 0x53, 0x6f, 0xff, 0x0c,
	0x16, 0x06, 0x5d, 0x4c, 0x54, 0x91, 0x47, 0x33, 0x04, 0x9c, 0x38, 0x39, 0xf4, 0xd4, 0x00, 0x4b,
	0xed, 0x43, 0x71, 0x9c, 0x8b, 0x3e, 0x80, 0x79, 0xc9, 0x97, 0x5f, 0x29, 0x7b, 0x33, 0x8b, 0xc2,
	0x31, 0x02, 0x0b, 0xc8, 0xd0, 0xa6, 0x41, 0x5c, 0xee, 0xc5, 0x42, 0xfd, 0x93, 0x02, 0x1b, 0xa3,
	0x2e, 0x1e, 0x66, 0xd6, 0x77, 0x27, 0x26, 0x84, 0xaf, 0xcf, 0x16, 0x1a, 0x93, 0x95, 0xad, 0x35,
	0x48, 0x56, 0xe1, 0xbb, 0xf7, 0x6e, 0x18, 0x6b, 0xa3, 0xa9, 0xfa, 0xd9, 0x3c, 0xac, 0xf3, 0xb0,
	0x1f, 0x2a, 0x8f, 0x49, 0xd8, 0xf7, 0xa2, 0xf0, 0xd5, 0x43, 0x62, 0x1f, 0x36, 0xa5, 0x66, 0xa6,
	0xf8, 0x34, 0x4c, 0x0c, 0xbf, 0x52, 0xc1, 0x77, 0x66, 0x2c, 0xbd, 0x09, 0x0d, 0x36, 0x24, 0xf6,
	0x18, 0x3d, 0x44, 0x14, 0xd6, 0xf9, 0xb8, 0x32, 0x29, 0x33, 0xfd, 0xba, 0x32, 0x57, 0x19, 0xf0,
	0x84, 0xc0, 0x8f, 0x60, 0x83, 0x7b, 0x6a, 0x8a, 0xc4, 0xb9, 0xd7, 0x95, 0xb8, 0xc6, 0x91, 0x27,
	0x44, 0xfe, 0x14, 0xb6, 0xc6, 0x3e, 0xf8, 0x93, 0x52, 0x97, 0xb8, 0x54, 0xed, 0xa6, 0x85, 0x66,
	0x28, 0xbd, 0xd4, 0x9e, 0xce, 0x08, 0x91, 0x05, 0x45, 0xee, 0xe4, 0xa4, 0xd8, 0xec, 0x6b, 0x8d,
	0xb9, 0x05, 0x86, 0x97, 0x14, 0x11, 0xc1, 0xca, 0x60, 0xde, 0x1b, 0x8a, 0x91, 0x23, 0x4d, 0xe5,
	0xc6, 0x6d, 0x28, 0x61, 0x1e, 0x8a, 0xf1, 0x13, 0x59, 0x19, 0xc0, 0xda, 0xb4, 0x79, 0x2e, 0x2c,
	0xe5, 0xb9, 0x75, 0xdf, 0x7a, 0xad, 0x49, 0x0e, 0xaf, 0x4e, 0x99, 0xe1, 0x42, 0xb4, 0x03, 0x19,
	0x12, 0x04, 0x34, 0x28, 0xe5, 0xb8, 0x6d, 0x28, 0x96, 0x11, 0xf4, 0xec, 0xb2, 0xc1, 0x1f, 0x6b,
	0xb0, 0xd8, 0xa0, 0x7e, 0xa6, 0xc0, 0xda, 0xd8, 0x6b, 0x4d, 0xd8, 0xa3, 0x7e, 0x48, 0x10, 0x05,
	0x34, 0x74, 0x92, 0x19, 0x88, 0xfc, 0x9c, 0xbd, 0xe5, 0x4c, 0xcf, 0x73, 0x7c, 0xcb, 0x1a, 0x27,
	0xa9, 0x7f, 0x57, 0x60, 0x63, 0x6c, 0x77, 0x33, 0xa0, 0x9d, 0x80, 0x84, 0x57, 0x94, 0x85, 0xfb,
	0x50, 0xec, 0xc9, 0x8d, 0x66, 0x8f, 0x04, 0x36, 0x6b, 0xc3, 0xac, 0x68, 0x66, 0x70, 0x21, 0xa6,
	0x37, 0x05, 0x19, 0xbd, 0x03, 0x30, 0x9c, 0x4f, 0xe4, 0x3b, 0xc3, 0xd6, 0x44, 0x73, 0x6b, 0xc5,
	0x6f, 0x5d, 0x38, 0x37, 0x98, 0x4c, 0xd0, 0xbb, 0x90, 0xef, 0xf7, 0x1c, 0x2b, 0x22, 0xe2, 0xec,
	0xdc, 0x95, 0x67, 0x41, 0x6c, 0x67, 0x04, 0xf5, 0x97, 0xe3, 0x6e, 0x1e, 0x58, 0x16, 0xc0, 0x4a,
	0xc2, 0xcd, 0xb1, 0xbe, 0xd2, 0xcf, 0xda, 0x8d, 0xfd, 0x1c, 0xe3, 0xe3, 0xc4, 0x25, 0xc6, 0x34,
	0xf5, 0xb7, 0x29, 0xd8, 0xbc, 0xf4, 0x59, 0x60, 0x72, 0x06, 0x50, 0x26, 0x67, 0x00, 0xe6, 0xf3,
	0xae, 0xf5, 0xc2, 0xb4, 0xbc, 0x88, 0x04, 0xbe, 0x15, 0xb9, 0xcf, 0xe5, 0x50, 0x99, 0xc1, 0x85,
	0xae, 0xf5, 0x42, 0x4b, 0x90, 0xd9, 0xd6, 0xb6, 0xcb, 0x08, 0xcc, 0xba, 0xb6, 0xe5, 0xb3, 0x21,
	0x21, 0x2d, 0xe6, 0x49, 0x41, 0x6f, 0xc6, 0x64, 0xf4, 0x21, 0x14, 0x64, 0xae, 0xc8, 0x27, 0xb9,
	0xb8, 0xe0, 0x7d, 0x63, 0xd6, 0x2c, 0x89, 0x1f, 0xe5, 0x96, 0xc3, 0xe4, 0x32, 0x44, 0x6f, 0xc2,
	0xa2, 0xd5, 0x77, 0x5c, 0xca, 0x92, 0xd1, 0x7e, 0x26, 0x4a, 0x4c, 0x06, 0xe7, 0x39, 0xad, 0xc5,
	0x49, 0xea, 0x7d, 0x58, 0x1a, 0xc1, 0x40, 0x25, 0x98, 0xef, 0x5d, 0x04, 0x56, 0x28, 0xbf, 0xb8,
	0x72, 0x38, 0x5e, 0xaa, 0x3f, 0x53, 0x60, 0x65, 0x8a, 0x23, 0xd1, 0x8f, 0x61, 0x71, 0xc4, 0x33,
	0xe2, 0x36, 0x0f, 0x67, 0x35, 0x02, 0x13, 0x9b, 0x76, 0x7c, 0x97, 0x97, 0xca, 0x21, 0x1c, 0x1e,
	0xc1, 0x56, 0x7f, 0xaf, 0xc0, 0xed, 0x57, 0x6d, 0x67, 0xc3, 0xe3, 0xb0, 0xf2, 0xc8, 0xcb, 0x4c,
	0x50, 0xae, 0x1a, 0x2e, 0xd1, 0x11, 0x64, 0x3e, 0xa6, 0x81, 0x13, 0x77, 0xbb, 0xfd, 0xeb, 0x5b,
	0xf1, 0x3d, 0x1a, 0x38, 0x35, 0xbf, 0x4d, 0xb1, 0x00, 0x50, 0x7f, 0xa5, 0xc0, 0x42, 0x4c, 0x43,
	0xdf, 0x1c, 0x49, 0xc5, 0x2b, 0x87, 0x99, 0x44, 0x26, 0x3e, 0x84, 0x85, 0xf8, 0x75, 0xe0, 0xea,
	0xef, 0xd3, 0x79, 0xf9, 0x2c, 0xc0, 0xc6, 0x00, 0xa6, 0x85, 0x9c, 0x68, 0xf9, 0xef, 0x07, 0xbf,
	0x53, 0x60, 0x5e, 0xbe, 0x0b, 0xa3, 0x0d, 0x58, 0x39, 0xd4, 0xb5, 0xd6, 0x29, 0xd6, 0xcd, 0xd3,
	0xba, 0xd1, 0xd4, 0x2b, 0xb5, 0xc3, 0x9a, 0x5e, 0x2d, 0xfe, 0x1f, 0x5a, 0x81, 0xc2, 0xb1, 0x76,
	0xa0, 0x1f, 0x9b, 0x55, 0xbd, 0xa5, 0x57, 0x5a, 0xb5, 0x46, 0xbd, 0xa8, 0xa0, 0x4d, 0x58, 0x33,
	0x8e, 0x1a, 0x2d, 0xb3, 0x72, 0xa4, 0xd5, 0x1f, 0xeb, 0x09, 0x56, 0x0a, 0xdd, 0x85, 0x2d, 0xfd,
	0xfb, 0xcd, 0xe3, 0x5a, 0xa5, 0xd6, 0x32, 0x2b, 0x8d, 0x7a, 0x4b, 0xaf, 0xb7, 0x12, 0xfc, 0x34,
	0x42, 0xb0, 0x7c, 0xa8, 0x55, 0x92, 0x67, 0x16, 0x50, 0x09, 0x56, 0x8d, 0xa6, 0xae, 0x57, 0x8e,
	0xcc, 0x16, 0xd6, 0xea, 0x46, 0x05, 0xd7, 0x9a, 0x9c, 0x93, 0x7d, 0x10, 0x00, 0x9a, 0x7c, 0xc0,
	0x42, 0xff, 0x0f, 0xdb, 0x63, 0x3a, 0x99, 0x27, 0x8d, 0xea, 0xb8, 0xe6, 0x4b, 0x90, 0xe3, 0x4a,
	0x32, 0x56, 0x51, 0x41, 0xcb, 0x00, 0x87, 0x58, 0x3b, 0xd1, 0xc5, 0x3a, 0xc5, 0x2c, 0xe6, 0x6c,
	0xad, 0x5e, 0x35, 0x13, 0x8c, 0xf4, 0x83, 0x08, 0x60, 0x38, 0xcd, 0xa1, 0x2d, 0x58, 0x3f, 0xae,
	0x7d, 0xa0, 0x1f, 0xd7, 0x8e, 0x1a, 0x8d, 0xea, 0x98, 0x84, 0x5b, 0xb0, 0x74, 0xa6, 0xe3, 0x27,
	0xe6, 0x69, 0x9d, 0x6f, 0x79, 0x52, 0x54, 0xd0, 0x22, 0x2c, 0x0c, 0x56, 0x29, 0xb6, 0x6a, 0x36,
	0x0c, 0xa3, 0x76, 0x70, 0xac, 0x17, 0xd3, 0x08, 0x20, 0x2b, 0x39, 0x73, 0xa8, 0x00, 0x79, 0x7e,
	0x54, 0x12, 0x32, 0x0f, 0xfe, 0xa9, 0xc0, 0xbc, 0xfc, 0x0a, 0x66, 0xaa, 0xe9, 0x27, 0x0d, 0x6e,
	0xd7, 0x84, 0x49, 0xda, 0xc9, 0xa9, 0xa1, 0x9f, 0xe8, 0xf5, 0x56, 0x51, 0x41, 0x39, 0xc8, 0x30,
	0xff, 0xe3, 0x62, 0x8a, 0xa9, 0x52, 0x69, 0xd4, 0x2b, 0x7a, 0xbd, 0x85, 0x35, 0xe9, 0xe9, 0x02,
	0xe4, 0xe5, 0x05, 0xf0, 0xed, 0x73, 0x4c, 0x7e, 0x55, 0x37, 0x6a, 0x58, 0x2f, 0x66, 0xd8, 0x35,
	0x54, 0x6b, 0x86, 0xd6, 0x6c, 0x36, 0x6a, 0x92, 0x9f, 0x45, 0x79, 0x98, 0xaf, 0xd6, 0x8c, 0xc7,
	0xa7, 0x46, 0xab, 0x38, 0xcf, 0x16, 0xfa, 0xb1, 0x26, 0x2f, 0xe8, 0x16, 0x2c, 0xe9, 0x27, 0x07,
	0x1a, 0xc6, 0x9a, 0x61, 0xf0, 0xcd, 0x39, 0x66, 0x5a, 0xad, 0xde, 0xd2, 0xb1, 0x6e, 0xb4, 0x8a,
	0xc0, 0x34, 0x69, 0xe2, 0x5a, 0x55, 0x2f, 0xe6, 0xd9, 0x41, 0x43, 0xab, 0xd6, 0x75, 0xc3, 0x28,
	0x2e, 0xb2, 0x5d, 0xc6, 0x29, 0x6e, 0xe2, 0x9a, 0xa1, 0x17, 0x97, 0xf6, 0xbf, 0x50, 0xa0, 0xc4,
	0x2b, 0x75, 0x2d, 0x91, 0x31, 0x06, 0x09, 0x9e, 0xbb, 0x36, 0x41, 0xbf, 0x56, 0x60, 0x69, 0xa4,
	0x49, 0xa0, 0x19, 0x66, 0xe3, 0x69, 0x7f, 0xb9, 0x6c, 0xdd, 0x89, 0xcf, 0x27, 0xfe, 0x0b, 0x2a,
	0x37, 0xe2, 0xff, 0x82, 0xd4, 0x2f, 0xfd, 0xfc, 0x6f, 0xff, 0xfa, 0x3c, 0x75, 0x4f, 0xdd, 0x1a,
	0xff, 0x7b, 0x2a, 0x7c, 0x24, 0xbb, 0x06, 0x79, 0xa4, 0x3c, 0x38, 0xf8, 0x24, 0x05, 0x5f, 0xb1,
	0x69, 0xf7, 0xda, 0xba, 0x1c, 0xdc, 0xb9, 0xcc, 0xc4, 0x26, 0x4b, 0xcf, 0xa6, 0xf2, 0x83, 0x27,
	0x12, 0xaa, 0x43, 0x59, 0x53, 0x29, 0xd3, 0xa0, 0xb3, 0xdb, 0x21, 0x3e, 0x4f, 0xde, 0x5d, 0xc1,
	0xb2, 0x7a, 0x6e, 0x78, 0xf5, 0x9f, 0x69, 0xef, 0x4e, 0xf0, 0xfe, 0x90, 0xda, 0x79, 0x2c, 0xb0,
	0x2b, 0x5c, 0xcd, 0x09, 0x4d, 0xca, 0x67, 0x7b, 0xcd, 0xbd, 0x03, 0x76, 0xf8, 0xaf, 0xf1, 0xd6,
	0xa7, 0x7c, 0xeb, 0xd3, 0x89, 0xad, 0x4f, 0xcf, 0x62, 0x39, 0xe7, 0x59, 0xae, 0xdb, 0xd7, 0xfe,
	0x1b, 0x00, 0x00, 0xff, 0xff, 0x9b, 0x29, 0xc9, 0x61, 0xe7, 0x1b, 0x00, 0x00,
}
